

    <style>
        body {
            background-color: #f8f9fa;
            font-family: 'Poppins', sans-serif;
        }

        /* Navbar Styling */
        .navbar {
            background-color: #ffffff;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            padding: 10px 15px;
        }

        /* Hero Section */
        .hero-section {
            height: 80vh;
            display: flex;
            justify-content: center;
            align-items: center;
            text-align: center;
            background: linear-gradient(rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0.5)), 
                        url('https://source.unsplash.com/1600x900/?office,workspace') 
                        no-repeat center center/cover;
            color: white;
            padding: 50px 20px;
        }

        /* Button Custom */
        .btn-custom {
            font-size: 1.2rem;
            padding: 12px 30px;
            border-radius: 30px;
            transition: 0.3s;
        }

        .btn-custom:hover {
            background-color: #28a745;
            color: white;
            transform: scale(1.05);
        }

        /* Contact Section */
        .contact-container {
            background: rgba(255, 255, 255, 0.9);
            padding: 50px;
            border-radius: 10px;
            max-width: 1000px;
            margin: 50px auto;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }

        .contact-title {
            font-size: 2rem;
            font-weight: bold;
            text-align: center;
            margin-bottom: 30px;
        }

        .contact-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
        }

        .contact-item {
            padding: 15px;
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            transition: 0.3s;
        }

        .contact-item:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
        }

        .contact-item h4 {
            font-size: 1.2rem;
            font-weight: bold;
            margin-bottom: 10px;
        }

        .whatsapp-link {
            display: flex;
            align-items: center;
            color: #25D366;
            font-weight: bold;
            text-decoration: none;
            margin-top: 10px;
        }

        .whatsapp-link i {
            font-size: 1.5rem;
            margin-right: 8px;
        }

        /* Responsif untuk tampilan HP */
        @media (max-width: 768px) {
            .hero-section {
                height: 70vh;
                padding: 30px 10px;
            }
            .hero-section h1 {
                font-size: 1.8rem;
            }
            .hero-section p {
                font-size: 1rem;
            }
            .btn-custom {
                font-size: 1rem;
                padding: 10px 20px;
            }
            .contact-container {
                padding: 20px;
            }
            .contact-title {
                font-size: 1.5rem;
            }
        }
    </style>


<body>

    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-light">
        <div class="container">
            <a href="index.html" class="navbar-brand">
                <img src="<?= base_url('/assets/img/asiaserv-logo.png'); ?>" alt="AsiaServ Logo" style="width: 120px; height: auto;">
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
        </div>
    </nav>

    <!-- Flash Messages -->
    <div id="flash" data-flash="<?= $this->session->flashdata('pesan_success'); ?>"></div>
            <?php if ($this->session->flashdata('pesan_error')): ?>
                <div class="alert alert-danger alert-dismissible bg-danger text-white border-0 fade show" role="alert">
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                    <?= $this->session->flashdata('pesan_error'); ?>
                </div>
            <?php endif; ?>

    <!-- Hero Section -->
    <section class="hero-section">
        <div>
            <h1 class="fw-bold">Sistem Pengambilan ATK</h1>
            <p class="lead">Kelola dan catat pengambilan alat tulis kantor dengan mudah dan cepat.</p>
            <a href="<?php echo site_url('Admin/ATK/Atk_Pengambilan_Controller/input_user'); ?>" data-bs-toggle="modal" data-bs-target="#InventoryModal1" 
                class="btn btn-success btn-lg btn-custom">
                <i class="fas fa-plus-circle"></i> Tambah Data
            </a>
        </div>
    </section>

    <!-- Contact Section -->
    <div class="contact-container">
        <div class="contact-title">Contact Us</div>

        <div class="contact-grid">

            <div class="contact-item">
                <h4>Contact GA</h4>
                <p><strong>Nama:</strong> Oki Awaludin</p>
                <p><strong>Email:</strong> oki.awaludin@asiaserv.com</p>
                <p>
                    <a href="https://wa.me/6285718101532" target="_blank" class="whatsapp-link">
                        <i class="fa-brands fa-whatsapp"></i> Chat via WhatsApp
                    </a>
                </p>
            </div>
        </div>
    </div>
