<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Inventory_Controller extends CI_Controller {

    public function __construct(){
		parent::__construct();
		$this->load->model("Inventory_model");
        $this->load->model("Location_model");
        $this->load->model("Inventory_Types_model");
		$this->load->library('session');
        $this->load->model('ATK_Product_model');
	}

	public function index()
{
    $this->load->model('Inventory_model');
    
    $data["all_inventory"] = $this->Inventory_model->getAll();
    $data["locations"] = $this->Location_model->getAll();
    $data["types"] = $this->Inventory_Types_model->getAll();
    $data['total_inventory'] = $this->Inventory_model->jumlah_inventory();
    $data['per_produk'] = $this->Inventory_model->jumlah_inventory_per_produk();

    $this->load->view('Admin/head');
    $this->load->view('Admin/inventory_dashboard', $data);
    $this->load->view('Admin/footer');
}


    public function input()
	{
		// $x['idKategori']=$this->kategori_model->autoId();
		$this->load->view('Admin/head');
		$this->load->view('Admin/Inventory/add');
		$this->load->view('Admin/footer');
	}

	
    public function tambah(){
		$inventory = $this->Inventory_model;
		$result =$inventory->save();
		if($result > 0) $this->sukses();
		else $this->gagal();	
		
	}

	function sukses(){
        $this->session->set_flashdata('pesan_success', 'Data Inventory hasil dibuat');
        redirect('Inventory_Controller');
	}

	function gagal(){
        $this->session->set_flashdata('pesan_error', 'Data Location berhasil dibuat');
        redirect('Inventory_Controller');
	}


    // public function view_ubah($inventory_id) {
    //     $where = array('inventory_id' => $inventory_id);
    //     $data['inventory'] = $this->Inventory_model->view_update($where, 'inventory')->row(); // Use row() for a single object
    //     $this->load->view('Admin/head');
    //     $this->load->view('Admin/Inventory/update', $data);
    //     $this->load->view('Admin/footer');
    // }

    public function view_ubah($inventory_id) {
        $where = array('inventory_id' => $inventory_id);
        $data['inventory'] = $this->Inventory_model->view_update($where, 'inventory')->row();
        $data['locations'] = $this->Location_model->getAll(); // untuk lokasi
        $data['types'] = $this->Inventory_Types_model->getAll(); // untuk tipe
        $this->load->view('Admin/head');
        $this->load->view('Admin/Inventory/update', $data);
        $this->load->view('Admin/footer');
    }
    
    

    // Simpan Ubah ke Database
    public function update(){

        date_default_timezone_set("Asia/Jakarta");
        $tanggal = date("Y-m-d H:i:s");

		$post = $this->input->post();	
		$inventory_id 		= $this->input->post('inventory_id');
        
        $inventory_nama = $this->input->post('inventory_nama');
        $inventory_SN = $this->input->post('inventory_SN');
        $inventory_location_id = $this->input->post('inventory_location_id');
        $inventory_types_id = $this->input->post('inventory_types_id');
        $inventory_remarks = $this->input->post('inventory_remarks');
        $inventory_price = $this->input->post('inventory_price');
        $inventory_material = $this->input->post('inventory_material');
        $inventory_qty = $this->input->post('inventory_qty');
        $updated_by = $this->input->post('updated_by');
        $updated_at = $tanggal;

   

        $data = array(
			'inventory_id'         => $inventory_id,
			'inventory_nama'       => $inventory_nama,
            'inventory_SN'       => $inventory_SN,
            'inventory_location_id'       => $inventory_location_id,
            'inventory_types_id'       => $inventory_types_id,
            'inventory_remarks'       => $inventory_remarks,
            'inventory_price'       => $inventory_price,
            'inventory_material'       => $inventory_material,
            'inventory_qty'       => $inventory_qty,
            'updated_by'       => $updated_by,
            'updated_at'       => $updated_at,
			'inventory_status'     => 1
        );

        $where = array(
            'inventory_id'       => $inventory_id
        );

        $this->Inventory_model->update($where,$data,'inventory');
        $this->session->set_flashdata('pesan_success', 'Data Inventory berhasil diubah');
        redirect('Inventory_Controller');
    }

	public function hapus($inventory_id){
		$data = array(
            'inventory_id'       => $inventory_id,
            'inventory_status'        => 0
        );

        $where = array(
            'inventory_id'       => $inventory_id
        );
        $this->Location_model->update($where,$data,'inventory');
        $this->session->set_flashdata('pesan_success', 'Data Location berhasil dihapus');
        redirect('Inventory_Controller');
    }

    public function test() {
    echo "Controller terhubung!";
}

public function dashboard()
{
    $filter_kategori = $this->input->get('filter_kategori');
    $filter_lokasi = $this->input->get('filter_lokasi');

    $this->load->model("Inventory_model");

    $data['total_inventory'] = $this->Inventory_model->jumlah_inventory();
    $data['per_produk'] = $this->Inventory_model->jumlah_inventory_per_produk();
    $data['product'] = $this->ATK_Product_model->getAll();

    // Untuk dropdown filter
    $data['categories'] = $this->ATK_Product_model->getAllCategories();
    $data['locations'] = $this->Location_model->getAll();
    $data['product'] = $this->ATK_Product_model->getFilteredProducts($filter_kategori, $filter_lokasi);

    $this->load->view('Admin/head');
     $this->load->view('Admin/inventory_dashboard', $data);
    $this->load->view('Admin/footer');
}


// Detail produk tertentu
    public function produk($nama)
    {
        $data['produk'] = $this->Inventory_model->get_by_nama(urldecode($nama));

        $this->load->view('Admin/head');
        $this->load->view('Admin/inventory_produk_detail', $data); 
        $this->load->view('Admin/footer');
    }

public function detail($product_id)
{
    $data['produk'] = $this->ATK_Product_model->getById($product_id);
    $this->load->view('Admin/head');
    $this->load->view('Admin/inventory_produk_detail', $data);
    $this->load->view('Admin/footer');
}

}
?>