<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Laporan Pengambilan ATK</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        h2 { text-align: center; margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; }
        table, th, td { border: 1px solid black; }
        th, td { padding: 6px; text-align: center; }
    </style>
</head>
<body>
    <h2>Laporan Pengambilan ATK</h2>
    <table>
        <thead>
            <tr>
                <th>No.</th>
                <th>Nama Peminjam</th>
                <th>Divisi</th>
                <th>Produk ATK</th>
                <th>Count</th>
                <th>Tanggal Pengambilan</th>
            </tr>
        </thead>
        <tbody>
            <?php $no=1; foreach($pengambilan as $p): ?>
            <tr>
                <td><?= $no++ ?></td>
                <td><?= $p->atk_pengambilan_peminjam ?></td>
                <td><?= $p->divisi_categories_nama ?></td>
                <td><?= $p->atk_product_nama ?></td>
                <td><?= $p->atk_pengambilan_jumlah ?></td>
                <td><?= date('d-m-Y', strtotime($p->tanggal_pengambilan)) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
