<!DOCTYPE html>
<head>
    <meta charset="UTF-8">
    <title>Sistem Pengambilan ATK</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        /* Variabel Warna Kustom */
        :root {
            --primary-color: #007bff; /* Biru Primer */
            --dark-blue: #0056b3; 
            --secondary-bg: #f3f5f9; /* Latar belakang abu-abu muda */
            --shadow-light: 0 4px 12px rgba(0, 0, 0, 0.1);
            --shadow-medium: 0 8px 25px rgba(0, 0, 0, 0.2);
        }

        body {
            background-color: var(--secondary-bg);
            font-family: 'Poppins', sans-serif;
            color: #333;
        }

        /* Navbar Styling */
        .navbar {
            background-color: #ffffff;
            box-shadow: var(--shadow-light);
            padding: 10px 20px;
        }

        .navbar-brand img {
            height: 60px; /* Sedikit lebih kecil dari sebelumnya agar tidak terlalu mendominasi navbar */
            transition: 0.3s;
        }
        
        /* Hero Section */
        .hero-section {
            height: 85vh; /* Sedikit lebih tinggi */
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
            /* Background dengan overlay Biru Tua/Navy */
            background: linear-gradient(rgba(0, 40, 80, 0.75), rgba(0, 40, 80, 0.75)),
                url('https://source.unsplash.com/1600x900/?office,workspace') no-repeat center center/cover;
            color: white;
            padding: 50px 20px;
        }

        .hero-section h1 {
            font-size: 3.5rem; /* Lebih besar */
            font-weight: 700;
            margin-top: 20px;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5); /* Shadow untuk keterbacaan */
        }

        .hero-section p {
            font-size: 1.3rem;
            font-weight: 300;
            margin: 15px 0 35px;
        }

        /* Button Custom (Warna Biru Primary) */
        .btn-custom {
            font-size: 1.1rem;
            padding: 12px 30px;
            border-radius: 50px;
            background: linear-gradient(45deg, var(--primary-color), var(--dark-blue)); /* Gradient biru */
            border: none;
            transition: 0.3s;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            font-weight: 600;
        }

        .btn-custom:hover {
            transform: translateY(-3px) scale(1.02); /* Efek hover yang lebih elegan */
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.4);
            color: white;
        }

        /* Contact Section */
        .contact-container {
            background: #ffffff;
            padding: 40px;
            border-radius: 12px;
            max-width: 1000px;
            margin: 80px auto; /* Margin atas lebih besar */
            box-shadow: var(--shadow-medium);
            border: 1px solid #ddd;
        }

        .contact-title {
            font-size: 2.2rem;
            font-weight: 700;
            text-align: center;
            margin-bottom: 40px;
            color: var(--primary-color);
        }

        .contact-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); /* Kolom lebih lebar */
            gap: 30px;
        }

        .contact-item {
            padding: 25px;
            background: var(--secondary-bg);
            border-radius: 10px;
            text-align: left; /* Rata kiri untuk detail */
            transition: 0.4s;
            border-left: 5px solid var(--primary-color); /* Garis border kiri */
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        .contact-item:hover {
            transform: translateY(-5px);
            background: #ffffff;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
        }

        .contact-item h4 {
            font-size: 1.4rem;
            font-weight: 600;
            margin-bottom: 15px;
            color: var(--dark-blue);
        }
        
        .contact-item p {
            margin-bottom: 5px;
            font-size: 1rem;
        }

        .whatsapp-link {
            display: inline-flex;
            align-items: center;
            color: #25D366;
            font-weight: 600;
            text-decoration: none;
            margin-top: 15px;
            transition: 0.3s;
        }

        .whatsapp-link:hover {
            color: #128C7E;
        }

        .whatsapp-link i {
            font-size: 1.6rem;
            margin-right: 10px;
        }

        /* Flash Message Styling */
        .alert {
            margin: 20px auto;
            max-width: 90%;
            border-radius: 8px;
            font-weight: 500;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .hero-section {
                height: 60vh;
            }

            .hero-section h1 {
                font-size: 2.5rem;
            }

            .contact-container {
                margin: 40px auto;
                padding: 30px;
            }
        }
    </style>
</head>

<body>

    <nav class="navbar navbar-light">
        <div class="container-fluid container">
            <a class="navbar-brand">
                <img src="<?= base_url('/assets/img/asiaserv-logo.png'); ?>" alt="AsiaServ Logo">
            </a>
        
        </div>
    </nav>


    <div class="container">
        <div id="flash" data-flash="<?= $this->session->flashdata('pesan_success'); ?>"></div>

        <?php if ($this->session->flashdata('pesan_error')): ?>
            <div class="alert alert-danger alert-dismissible fade show d-flex align-items-center" role="alert">
                 <i class="fas fa-times-circle me-2"></i>
                <?= $this->session->flashdata('pesan_error'); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php if ($this->session->flashdata('success')): ?>
            <div class="alert alert-success alert-dismissible fade show d-flex align-items-center" role="alert">
                <i class="fas fa-check-circle me-2"></i>
                <?= $this->session->flashdata('success'); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
    </div>


    <section class="hero-section">
        <div>
            <img src="<?= base_url('assets/img/logo-asiaserv.png'); ?>" alt="Logo White" style="height: 200px; margin-bottom: 20px;">
            <h1>Stationery Supply System</h1>
            <p>Manage and record office stationery usage easily and quickly.</p>
            <a href="#" data-bs-toggle="modal" data-bs-target="#InventoryModal1" class="btn btn-custom btn-lg">
                <i class="fas fa-hand-paper me-2"></i> Submit ATK Requisition
            </a>
        </div>
    </section>

    <div class="contact-container">
        <div class="contact-title"><i class="fas fa-headset me-2"></i> Need Assistance? Contact Us</div>
        <div class="contact-grid">
            
            <div class="contact-item">
                <h4><i class="fas fa-user-tie me-2"></i> General Affairs (GA) PIC</h4>
                <p><strong>Name:</strong> Oki Awaludin</p>
                <p><strong>Role:</strong> General Affairs Manager</p>
                <p><strong>Email:</strong> <a href="mailto:oki.awaludin@gmail.com" class="text-decoration-none text-primary">oki.awaludin@gmail.com</a></p>
                <p>
                    <a href="https://wa.me/6285718101532" target="_blank" class="whatsapp-link">
                        <i class="fa-brands fa-whatsapp"></i> Chat Oki via WhatsApp
                    </a>
                </p>
            </div>
            

        </div>
    </div>


    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    </body>
</html>