<div class="container mt-5">
    <div class="card shadow-lg border-0">
        <div class="card-header bg-warning text-dark d-flex align-items-center p-3">
            <i class="fas fa-edit fa-lg me-3"></i>
            <h5 class="m-0 fw-bold">Edit ATK Retrieval (Pengambilan ATK)</h5>
        </div>
        
        <div class="card-body p-4">
            <form action="<?= site_url('Admin/ATK/Atk_Pengambilan_Controller/update'); ?>" method="post">
                <input type="hidden" name="id" value="<?= $pengambilan->id; ?>">
                <input type="hidden" name="atk_product_id" value="<?= $pengambilan->atk_pengambilan_product; ?>">
                <input type="hidden" name="atk_pengambilan_product" value="<?= $pengambilan->atk_pengambilan_product ?>">
                <input type="hidden" name="atk_pengambilan_peminjam" value="<?= $pengambilan->atk_pengambilan_peminjam ?>">
                <input type="hidden" name="atk_pengambilan_divisi" value="<?= $pengambilan->atk_pengambilan_divisi ?>">
                <input type="hidden" name="atk_pengambilan_lokasi" value="<?= $pengambilan->atk_pengambilan_lokasi ?>">

                <div class="row g-3 mb-4">
                    <div class="col-md-6">
                        <label class="form-label fw-semibold text-muted">Nama Peminjam</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-user"></i></span>
                            <input type="text" class="form-control" value="<?= $pengambilan->atk_pengambilan_peminjam ?>" readonly>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-semibold text-muted">Divisi</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-sitemap"></i></span>
                            <input type="text" class="form-control" value="<?= $pengambilan->divisi_categories_nama ?>" readonly>
                        </div>
                    </div>
                </div>

                <div class="row g-3 mb-4">
                    <div class="col-md-6">
                        <label class="form-label fw-semibold text-muted">Produk ATK</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-box"></i></span>
                            <input type="text" class="form-control" value="<?= $pengambilan->atk_product_nama ?>" readonly> 
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-semibold text-muted">Lokasi Inventory</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-warehouse"></i></span>
                            <input type="text" class="form-control" value="<?= $pengambilan->inventory_location_nama ?>" readonly> 
                        </div>
                    </div>
                </div>

                <hr class="mb-4">
                
                <div class="row g-4">
                    <div class="col-md-4">
                        <label class="form-label fw-semibold text-muted">Tanggal Pengambilan</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-calendar-alt"></i></span>
                            <input type="text" class="form-control" value="<?= date('d-m-Y', strtotime($pengambilan->tanggal_pengambilan)); ?>" readonly>
                            <input type="hidden" name="tanggal_pengambilan" value="<?= $pengambilan->tanggal_pengambilan ?>">
                        </div>
                    </div>

                    <div class="col-md-4">
                        <label for="atk_pengambilan_jumlah" class="form-label fw-semibold">Jumlah Diambil <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-cubes"></i></span>
                            <input type="number" class="form-control" id="atk_pengambilan_jumlah" name="atk_pengambilan_jumlah"
                                value="<?= $pengambilan->atk_pengambilan_jumlah ?>" placeholder="Masukkan jumlah pengambilan" min="1" required>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <label for="atk_pengambilan_status" class="form-label fw-semibold">Status <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-info-circle"></i></span>
                            <select class="form-select" name="atk_pengambilan_status" id="atk_pengambilan_status" required>
                                <option value="1" <?= $pengambilan->atk_pengambilan_status == 1 ? 'selected' : '' ?>>1 - Processed (Diproses)</option>
                                <option value="2" <?= $pengambilan->atk_pengambilan_status == 2 ? 'selected' : '' ?>>2 - Finished (Selesai)</option>
                                <option value="3" <?= $pengambilan->atk_pengambilan_status == 3 ? 'selected' : '' ?>>3 - Rejected (Ditolak)</option>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="mt-4">
                    <label for="notes" class="form-label fw-semibold">Catatan (Notes)</label>
                    <textarea class="form-control" id="notes" name="notes" rows="3"
                        placeholder="Tambahkan catatan khusus, misalnya alasan perubahan atau penolakan..."><?= $pengambilan->notes ?? '' ?></textarea>
                </div>

                <div class="d-flex justify-content-end mt-5">
                    <a href="<?= site_url('Admin/ATK/Atk_Pengambilan_Controller/index'); ?>" class="btn btn-secondary me-3">
                        <i class="fas fa-times-circle me-1"></i> Batal
                    </a>
                    <button type="submit" class="btn btn-warning fw-bold text-dark">
                        <i class="fas fa-sync-alt me-1"></i> Update Data
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>