<style>
/* Memastikan semua isi tabel terpusat (vertical & horizontal) */
#datatables th, 
#datatables td {
    /* ** PAKSA SEMUA SEL RATA TENGAH SECARA DEFAULT ** */
    text-align: center !important; 
    vertical-align: middle; 
}

/* Mempertahankan kolom Nama Peminjam (Kolom ke-2), Produk ATK (Kolom ke-5), 
   dan Notes (Kolom ke-8) rata kiri untuk keterbacaan, MENGESAMPINGKAN rata tengah default di atas */
#datatables td:nth-child(2), /* Nama Peminjam */
#datatables td:nth-child(5), /* Produk ATK */
#datatables td:nth-child(8) /* Notes */
{
    text-align: left !important; 
}

/* Style tambahan untuk membuat tombol group lebih ringkas */
.btn-action-group {
    display: flex;
    gap: 8px;
}
</style>

<div class="container-fluid pt-4 px-4">
    <div class="card shadow-lg border-0 mb-4"> 
        
        <div class="card-header bg-primary text-white py-4 d-flex justify-content-between align-items-center">
            <h5 class="m-0 fw-bold">
                <i class="fas fa-history me-2"></i> Retrieval Data (Data Pengambilan ATK)
            </h5>
            
            <div class="btn-action-group">
                <a href="<?= site_url('Admin/ATK/Atk_Pengambilan_Controller/tambah'); ?>"
                    class="btn btn-warning fw-bold shadow-sm"
                    data-bs-toggle="modal" data-bs-target="#InventoryModal" 
                    title="Tambah Data Pengambilan Baru">
                    <i class="fas fa-plus me-1"></i> Add Data
                </a>
                
                <a href="<?= site_url('Admin/ATK/Atk_Pengambilan_Controller/export_excel?filter_produk=' . urlencode($filter_produk) . '&filter_divisi=' . urlencode($filter_divisi) . '&filter_lokasi=' . urlencode($filter_lokasi)) ?>" 
                    class="btn btn-success shadow-sm" title="Export to Excel">
                    <i class="fas fa-file-excel me-1"></i> Excel
                </a>

                <a href="<?= site_url('Admin/ATK/Atk_Pengambilan_Controller/cetak_pdf?filter_produk=' . urlencode($filter_produk) . '&filter_divisi=' . urlencode($filter_divisi) . '&filter_lokasi=' . urlencode($filter_lokasi)) ?>" 
                    id="btn-cetak-pdf" class="btn btn-danger shadow-sm" title="Print/Export to PDF">
                    <i class="fas fa-file-pdf me-1"></i> PDF
                </a>
            </div>
        </div>

        <div class="card-body border-bottom bg-light p-4">
            <h6 class="text-primary mb-3"><i class="fas fa-filter me-2"></i> Data Filter</h6>
            <form action="<?= site_url('Admin/ATK/Atk_Pengambilan_Controller/index'); ?>" method="get">
                <div class="row g-3 align-items-end mb-3">
                    <div class="col-md-6 col-lg-4">
                        <label for="filterProduk" class="form-label text-muted fw-bold small">Filter by Produk:</label>
                        <select class="form-select" id="filterProduk" name="filter_produk">
                            <option value="">-- All Produk --</option>
                            <?php foreach ($produk as $p): ?>
                                <option value="<?= $p->atk_product_id ?>" <?= ($filter_produk == $p->atk_product_id ? 'selected' : '') ?>>
                                    <?= $p->atk_product_nama ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="col-md-6 col-lg-4">
                        <label for="filterDivisi" class="form-label text-muted fw-bold small">Filter by Divisi:</label>
                        <select class="form-select" id="filterDivisi" name="filter_divisi">
                            <option value="">-- All Divisi --</option>
                            <?php foreach ($divisi as $d): ?>
                                <option value="<?= $d->divisi_categories_id ?>" <?= ($filter_divisi == $d->divisi_categories_id ? 'selected' : '') ?>>
                                    <?= $d->divisi_categories_nama ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="col-md-6 col-lg-4">
                        <label for="filterLokasi" class="form-label text-muted fw-bold small">Filter by Location:</label>
                        <select class="form-select" id="filterLokasi" name="filter_lokasi">
                            <option value="">-- All Location --</option>
                            <?php foreach ($lokasi as $l): ?>
                                <option value="<?= $l->inventory_location_id ?>" <?= ($filter_lokasi == $l->inventory_location_id ? 'selected' : '') ?>>
                                    <?= $l->inventory_location_nama ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>

                <button type="submit" class="btn btn-primary fw-bold shadow-sm mt-2">
                    <i class="fas fa-search me-1"></i> Apply Filter
                </button>
            </form>
        </div>

        <div class="card-body"> 
            <div id="flash" data-flash="<?= $this->session->flashdata('pesan_success'); ?>"></div>
            
            <?php if ($this->session->flashdata('pesan_error')): ?>
                <div class="alert alert-danger alert-dismissible fade show d-flex align-items-center" role="alert">
                    <i class="fas fa-times-circle me-2"></i>
                    <?= $this->session->flashdata('pesan_error'); ?>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            
            <?php if ($this->session->flashdata('success')): ?>
                <div class="alert alert-success alert-dismissible fade show d-flex align-items-center" role="alert">
                    <i class="fas fa-check-circle me-2"></i>
                    <?= $this->session->flashdata('success') ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover align-middle" id="datatables" style="width:100%">
                    <thead class="table-primary">
                        <tr>
                            <th class="text-center">No</th>
                            <th>Name</th>
                            <th>Division</th>
                            <th>Location</th>
                            <th>Product ATK</th> 
                            <th>Count</th>
                            <th>Pickup Date</th>
                            <th class="text-center">Notes</th>
                            <th class="text-center">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $i = 1; ?>
                        <?php foreach ($pengambilan as $k): ?>
                            <tr>
                                <td class="text-center fw-medium"><?= $i++; ?></td>
                                
                                <td class="text-start"><?= $k->atk_pengambilan_peminjam; ?></td>
                                
                                <td><?= $k->divisi_categories_nama; ?></td>
                                
                                <td><?= $k->inventory_location_nama; ?></td>
                                
                                <td class="text-start"><?= $k->atk_product_nama; ?></td>
                                
                                <td><span class="badge bg-primary fw-bold"><?= $k->atk_pengambilan_jumlah; ?></span></td>

                                <td><?= date('d-m-Y', strtotime($k->tanggal_pengambilan)); ?></td>
                                
                                <td><?= $k->notes; ?></td> 

                                <td class="text-center">
                                    <a href="<?= site_url('Admin/ATK/Atk_Pengambilan_Controller/view_ubah/'.$k->id); ?>" 
                                        class="btn btn-warning btn-sm shadow-sm" title="Edit Data">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <a href="<?= base_url('Admin/ATK/Atk_Pengambilan_Controller/hapus/'.$k->id); ?>" 
                                        class="btn btn-danger btn-sm shadow-sm btn-delete" 
                                        id="tombol-hapus" title="Hapus Data">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>  
        </div>
    </div>
</div>

<script>
$(document).ready(function () {
    // Hapus instance lama sebelum bikin baru
    if ($.fn.DataTable.isDataTable('#datatables')) {
        $('#datatables').DataTable().clear().destroy();
    }

    // Inisialisasi DataTables
    var table = $('#datatables').DataTable({
        ordering: true,
        searching: true,
        paging: true,
        columnDefs: [
            { orderable: false, targets: -1 } // Action column not sortable
        ],
        // Mengatur urutan default berdasarkan Pickup Date (kolom ke-6) secara descending
        order: [[6, "desc"]]
    });
    
    // === CETAK PDF ===
    $('#btn-cetak-pdf').off('click').on('click', function (e) {
        // Mengikuti link PHP yang sudah ada
    });
});
</script>