<div class="container mt-5">
    <div class="card shadow-lg border-0">
        <div class="card-header bg-warning text-dark d-flex align-items-center p-3">
            <i class="fas fa-box-open fa-lg me-3"></i> <h5 class="m-0 fw-bold">Edit Data ATK (Alat Tulis Kantor)</h5>
        </div>
        
        <div class="card-body p-4">
            <form action="<?php echo site_url('Admin/ATK/Atk_Product_Controller/update'); ?>" method="post">
                <input type="hidden" name="atk_product_id" value="<?= $product->atk_product_id; ?>">

                <div class="row g-4 mb-4">
                    <div class="col-md-4">
                        <label for="atk_product_categories" class="form-label fw-semibold">Kategori ATK <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-folder"></i></span>
                            <select class="form-select" id="atk_product_categories" name="atk_product_categories" >
                                <option value="">-- Pilih Kategori --</option>
                                <?php foreach ($kategori as $inventory): ?>
                                    <option value="<?= $inventory->atk_categories_id; ?>" <?= set_select('atk_categories', $inventory->atk_categories_id, $product->atk_product_categories == $inventory->atk_categories_id); ?>>
                                        <?= $inventory->atk_categories_nama; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <label for="atk_product_brand" class="form-label fw-semibold">Brand ATK <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-tag"></i></span>
                            <select class="form-select" id="atk_product_brand" name="atk_product_brand" >
                                <option value="">-- Pilih Brand --</option>
                                <?php foreach ($brand as $inventory): ?>
                                    <option value="<?= $inventory->brand_categories_id; ?>" <?= set_select('brand_categories', $inventory->brand_categories_id, $product->atk_product_brand == $inventory->brand_categories_id); ?>>
                                        <?= $inventory->brand_categories_nama; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <label for="atk_product_nama" class="form-label fw-semibold">Nama ATK <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-pencil-alt"></i></span>
                            <input type="text" class="form-control" id="atk_product_nama" name="atk_product_nama" 
                                value="<?= set_value('atk_product_nama', $product->atk_product_nama); ?>" 
                                placeholder="Masukkan nama ATK" >
                        </div>
                    </div>
                </div>

                <div class="row g-4 mb-4">
                    <div class="col-md-4">
                        <label for="atk_product_stok" class="form-label fw-semibold">Stok Saat Ini <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-cubes"></i></span>
                            <input type="number" class="form-control" id="atk_product_stok" name="atk_product_stok" 
                                value="<?= set_value('atk_product_stok', $product->atk_product_stok); ?>" 
                                placeholder="Masukkan stok ATK" min="0" >
                        </div>
                    </div>

                    <div class="col-md-4">
                        <label for="atk_product_uom" class="form-label fw-semibold">Satuan (UoM) <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-ruler-combined"></i></span>
                            <select class="form-select" id="atk_product_uom" name="atk_product_uom">
                                <option value="" disabled selected>-- Pilih Satuan --</option>
                                <?php foreach ($uom as $loc): ?>
                                    <option value="<?= $loc->uom_categories_id; ?>" <?= set_select('uom_categories', $loc->uom_categories_id, $product->atk_product_uom == $loc->uom_categories_id); ?>>
                                        <?= $loc->uom_categories_nama; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <label for="atk_product_location" class="form-label fw-semibold">Lokasi Inventory <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-warehouse"></i></span>
                            <select class="form-select" id="atk_product_location" name="atk_product_location" >
                                <option value="" disabled selected>-- Pilih Lokasi --</option>
                                <?php foreach ($locations as $loc): ?>
                                    <option value="<?= $loc->inventory_location_id; ?>" <?= set_select('inventory_location', $loc->inventory_location_id, $product->atk_product_location == $loc->inventory_location_id); ?>>
                                        <?= $loc->inventory_location_nama; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="row g-4 mb-4">
                    <div class="col-md-4">
                        <label for="update_date" class="form-label fw-semibold">Tanggal Update Terakhir</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-calendar-alt"></i></span>
                            <input type="datetime-local" class="form-control" id="update_date" name="update_date" 
                            value="<?= date('Y-m-d\TH:i'); ?>">
                        </div>
                    </div>
                    <div class="col-md-8">
                        <label for="atk_product_notes" class="form-label fw-semibold">Catatan (Notes)</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-comment-alt"></i></span>
                            <input type="text" class="form-control" id="atk_product_notes" name="atk_product_notes" 
                                value="<?= set_value('atk_product_notes', $product->atk_product_notes); ?>" 
                                placeholder="Tambahkan catatan khusus (misalnya: warna, ukuran, dsb.)">
                        </div>
                    </div>
                </div>

                <hr class="mt-4 mb-4">

                <div class="d-flex justify-content-end">
                    <a href="<?php echo site_url('Admin/ATK/Atk_Product_Controller/index'); ?>" class="btn btn-secondary me-3">
                        <i class="fas fa-times me-1"></i> Batal
                    </a>
                    <button type="submit" class="btn btn-warning fw-bold text-dark">
                        <i class="fas fa-save me-1"></i> Simpan Perubahan
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<script>
    function setCurrentDateTime() {
        const now = new Date();

        // format manual ke YYYY-MM-DDTHH:MM (waktu lokal)
        const year = now.getFullYear();
        const month = String(now.getMonth() + 1).padStart(2, '0');
        const day = String(now.getDate()).padStart(2, '0');
        const hour = String(now.getHours()).padStart(2, '0');
        const minute = String(now.getMinutes()).padStart(2, '0');

        const localDatetime = `${year}-${month}-${day}T${hour}:${minute}`;

        document.getElementById('update_date').value = localDatetime;
    }

    setCurrentDateTime();
</script>
