<div class="container mt-5">
    <div class="card shadow-lg border-0">
        <div class="card-header bg-warning text-dark d-flex align-items-center p-3">
            <i class="fas fa-cubes fa-lg me-3"></i> <h5 class="m-0 fw-bold">Edit Detail Inventory / Aset</h5>
        </div>
        
        <div class="card-body p-4">
            <form action="<?php echo site_url('Inventory_Controller/update'); ?>" method="post">
                <input type="hidden" name="inventory_id" value="<?= $inventory->inventory_id; ?>">
                <input type="hidden" name="updated_by" value="<?php echo $this->session->userdata('user_id'); ?>">

                <div class="row g-4 mb-4">
                    <div class="col-md-6">
                        <label for="inventory_nama" class="form-label fw-semibold">Nama Inventory <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-box-open"></i></span>
                            <input type="text" class="form-control" id="inventory_nama" name="inventory_nama" 
                                value="<?= set_value('inventory_nama', $inventory->inventory_nama); ?>" 
                                placeholder="Masukkan nama Inventory" required autofocus>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label for="inventory_SN" class="form-label fw-semibold">Nomor Seri (Serial Number)</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-barcode"></i></span>
                            <input type="text" class="form-control" id="inventory_SN" name="inventory_SN" 
                                value="<?= set_value('inventory_SN', $inventory->inventory_SN); ?>" 
                                placeholder="Masukkan Serial Number">
                        </div>
                    </div>
                </div>

                <div class="row g-4 mb-4">
                    <div class="col-md-6">
                        <label for="inventory_location_id" class="form-label fw-semibold">Lokasi Inventory <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-warehouse"></i></span>
                            <select class="form-select" id="inventory_location_id" name="inventory_location_id" required>
                                <option value="" disabled selected>Pilih Lokasi</option>
                                <?php foreach ($locations as $loc): ?>
                                    <option value="<?= $loc->inventory_location_id; ?>" <?= set_select('inventory_location', $loc->inventory_location_id, $inventory->inventory_location_id == $loc->inventory_location_id); ?>>
                                        <?= $loc->inventory_location_nama; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label for="inventory_types_id" class="form-label fw-semibold">Tipe Inventory <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-tools"></i></span>
                            <select class="form-select" id="inventory_types_id" name="inventory_types_id" required>
                                <option value="" disabled selected>Pilih Tipe</option>
                                <?php foreach ($types as $type): ?>
                                    <option value="<?= $type->inventory_types_id; ?>" <?= set_select('inventory_types', $type->inventory_types_id, $inventory->inventory_types_id == $type->inventory_types_id); ?>>
                                        <?= $type->inventory_types_nama; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
                
                <hr class="mb-4">
                
                <div class="row g-4 mb-4">
                    <div class="col-md-3">
                        <label for="inventory_qty" class="form-label fw-semibold">Kuantitas (Quantity) <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-sort-numeric-up-alt"></i></span>
                            <input type="number" class="form-control" id="inventory_qty" name="inventory_qty" 
                                value="<?= set_value('inventory_qty', $inventory->inventory_qty); ?>" 
                                placeholder="Jumlah" min="1" required>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <label for="inventory_price" class="form-label fw-semibold">Harga (Price)</label>
                        <div class="input-group">
                            <span class="input-group-text">Rp</span>
                            <input type="number" class="form-control" id="inventory_price" name="inventory_price" 
                                value="<?= set_value('inventory_price', $inventory->inventory_price); ?>" 
                                placeholder="Harga Beli/Aset" min="0">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label for="inventory_material" class="form-label fw-semibold">Material / Spesifikasi Dasar</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-industry"></i></span>
                            <input type="text" class="form-control" id="inventory_material" name="inventory_material" 
                                value="<?= set_value('inventory_material', $inventory->inventory_material); ?>" 
                                placeholder="Contoh: Plastik, Besi, Model, dsb.">
                        </div>
                    </div>
                </div>

                <div class="mb-4">
                    <label for="inventory_remarks" class="form-label fw-semibold">Keterangan (Remarks)</label>
                    <textarea class="form-control" id="inventory_remarks" name="inventory_remarks" rows="3"
                        placeholder="Tambahkan keterangan atau detail penting lainnya..."><?= set_value('inventory_remarks', $inventory->inventory_remarks); ?></textarea>
                </div>
                
                <hr class="mt-5 mb-4">

                <div class="d-flex justify-content-end">
                    <a href="<?php echo site_url('Inventory_Controller/index'); ?>" class="btn btn-secondary me-3">
                        <i class="fas fa-times me-1"></i> Batal
                    </a>
                    <button type="submit" class="btn btn-warning fw-bold text-dark">
                        <i class="fas fa-save me-1"></i> Simpan Perubahan
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>