<div class="container-fluid pt-4 px-4">
    <div class="card shadow-lg border-0 mb-4">
        
        <div class="card-header bg-primary text-white py-4 d-flex justify-content-between align-items-center">
            <h5 class="m-0 fw-bold">
                <i class="fas fa-map-marker-alt me-2"></i> Master Location
            </h5>
            <span style="float: right">
                <a href="<?php echo site_url('Admin/Inventory/Inventory_Location_Controller/input'); ?>" 
                   class="btn btn-warning fw-bold shadow-sm" 
                   data-bs-toggle="modal" 
                   data-bs-target="#LocationModal">
                   <i class="fas fa-plus me-1"></i> Add Data
                </a>
            </span>
        </div>

        <div class="card-body">
            <div id="flash" data-flash="<?= $this->session->flashdata('pesan_success'); ?>"></div>
            
            <?php if ($this->session->flashdata('pesan_success')): ?>
                <div class="alert alert-success alert-dismissible fade show d-flex align-items-center" role="alert">
                    <i class="fas fa-check-circle me-2"></i>
                    <?= $this->session->flashdata('pesan_success'); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            
            <?php if ($this->session->flashdata('pesan_error')): ?>
                <div class="alert alert-danger alert-dismissible fade show d-flex align-items-center" role="alert">
                    <i class="fas fa-times-circle me-2"></i>
                    <?= $this->session->flashdata('pesan_error'); ?>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover align-middle" id="datatables" style="width:100%">
                    <thead class="table-dark">
                        <tr>
                            <th class="text-center" style="width: 5%;">No.</th>
                            <th>Location Name</th>
                            <th class="text-center" style="width: 15%;">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $i = 1; ?>
                        <?php foreach ($location as $k): ?>
                            <tr>
                                <td class="text-center fw-medium"><?= $i++; ?></td>
                                <td><?= $k->inventory_location_nama; ?></td>

                                <td class="text-center">
                                    <a href="<?= site_url('Admin/Inventory/Inventory_Location_Controller/view_ubah/'.$k->inventory_location_id); ?>" 
                                       class="btn btn-warning btn-sm shadow-sm" title="Edit">
                                        <i class="fas fa-edit"></i> Edit
                                    </a>
                                    <a href="<?= base_url('Admin/Inventory/Inventory_Location_Controller/hapus/'.$k->inventory_location_id); ?>" 
                                       class="btn btn-danger btn-sm shadow-sm" 
                                       id="tombol-hapus" title="Hapus">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div> 
        </div>
    </div>
</div>

<script>
    // Assuming you have jQuery and DataTables loaded
    $(document).ready(function() {
        $('#datatables').DataTable();
        
        // --- NOTE: Add your existing SweetAlert logic here if needed. ---
        // For example, the code for 'tombol-hapus'
        $('#tombol-hapus').on('click', function(e) {
            e.preventDefault();
            const url = $(this).attr('href');
            // Your original SweetAlert code for delete confirmation goes here...
            // Swal.fire({ ... }).then((result) => { if (result.isConfirmed) { window.location.href = url; } });
        });
    });
</script>