<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
<div class="container-fluid pt-4 px-4"> 

    <h3 class="mb-4 text-primary fw-bold"><i class="fas fa-chart-bar me-2"></i>Admin Dashboard</h3>
    <hr class="mb-4">

    <div id="flash" data-flash="<?=$this->session->flashdata('pesan_success'); ?>"></div>
    <div id="flash_error" data-flash="<?=$this->session->flashdata('pesan_error'); ?>"></div>
    <?php if ($this->session->flashdata('pesan_error')): ?>
        <div class="alert alert-danger alert-dismissible fade show border-0 shadow-sm" role="alert">
            <i class="fas fa-exclamation-triangle me-2"></i>
            <strong>Error!</strong> <?= $this->session->flashdata('pesan_error'); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="row g-4 mb-4">
        
        <div class="col-sm-6 col-xl-6">
            <a href="<?= site_url('Admin/Admin_Dashboard_Controller/rekap_pengambilan') ?>" class="text-decoration-none h-100 d-block">
                <div class="card p-3 bg-white border-0 shadow-lg summary-card border-start border-5 border-info h-100">
                    <div class="d-flex align-items-center justify-content-between">
                        <i class="fas fa-users-cog fa-4x text-info"></i>
                        <div class="ms-3 text-end">
                            <p class="mb-1 text-muted fw-semibold">Summary of Employees Collecting</p> 
                            <h4 class="mb-0 text-dark">Employee Collection</h4>
                        </div>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-sm-6 col-xl-6">
            <a href="<?= site_url('Admin/Inventory/Inventory_Controller/dashboard'); ?>" class="text-decoration-none h-100 d-block">
                <div class="card p-3 bg-white border-0 shadow-lg summary-card border-start border-5 border-success h-100">
                    <div class="d-flex align-items-center justify-content-between">
                        <i class="fas fa-warehouse fa-4x text-success"></i>
                        <div class="ms-3 text-end">
                            <p class="mb-1 text-muted fw-semibold">Summary of Available Inventory</p>
                            <h4 class="mb-0 text-dark">Current Stock</h4>
                        </div>
                    </div>
                </div>
            </a>
        </div>
    </div>

    <div class="row g-4">
        
        <div class="col-12">
            <div class="card bg-white rounded p-4 border-0 shadow-sm">
                <h5 class="mb-3 text-dark"><i class="fas fa-sliders-h me-2"></i>Collection Data Filter</h5>
                <form method="get" action="<?= site_url('Admin/Admin_Dashboard_Controller/index') ?>" class="row g-3 align-items-center">
                    <div class="col-auto">
                        <label for="filterBulan" class="form-label visually-hidden">Month</label>
                        <select name="bulan" id="filterBulan" class="form-select border-primary">
                            <option value="" <?= ($bulan_filter == "") ? "selected" : "" ?>>All Months</option>
                            <?php 
                            $nama_bulan_en = [
                                1=>"January",2=>"February",3=>"March",4=>"April",5=>"May",6=>"June",
                                7=>"July",8=>"August",9=>"September",10=>"October",11=>"November",12=>"December"
                            ];
                            foreach ($nama_bulan_en as $key => $nama) {
                                $selected = ($bulan_filter == $key) ? "selected" : ""; 
                                echo "<option value='$key' $selected>$nama</option>";
                            }
                            ?>
                        </select>
                    </div>
                    <div class="col-auto">
                        <label for="filterTahun" class="form-label visually-hidden">Year</label>
                        <select name="tahun" id="filterTahun" class="form-select border-primary">
                            <?php 
                            $tahun_sekarang = date('Y');
                            $tahun_filter_val = $tahun_filter ?? $tahun_sekarang;
                            // Set start year, e.g., 5 years back
                            $start_year = $tahun_sekarang - 5; 
                            for ($t = $tahun_sekarang; $t >= $start_year; $t--) {
                                $selected = ($tahun_filter_val == $t) ? "selected" : "";
                                echo "<option value='$t' $selected>$t</option>";
                            }
                            ?>
                        </select>
                    </div>
                    <div class="col-auto">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-filter me-1"></i> Apply Filter
                        </button>
                    </div>
                    <div class="col-auto">
                        <a href="<?= site_url('Admin/Admin_Dashboard_Controller/index') ?>" class="btn btn-outline-secondary">
                             <i class="fas fa-sync-alt me-1"></i> Reset
                        </a>
                    </div>
                </form>
            </div>
        </div>

        <hr class="mt-4 mb-3">

        <div class="col-12">
            <div class="card bg-white rounded p-4 border-0 shadow-sm chart-card">
                <h5 class="mb-4 text-dark"><i class="far fa-calendar-alt me-2"></i>Monthly Collection Diagram for Year <?= $tahun_filter ?? date('Y') ?></h5>
                <canvas id="atkChart"></canvas>
            </div>
        </div>

        <?php if (!empty($jumlah_minggu)) : ?>
        <div class="col-12">
            <div class="card bg-white rounded p-4 border-0 shadow-sm chart-card">
                <h5 class="mb-4 text-dark">
                    <i class="fas fa-calendar-week me-2"></i>Weekly Collection Diagram 
                    <?php if (empty($bulan_filter)) : ?>
                        (All Months)
                    <?php else : ?>
                        (Month <?= $nama_bulan_en[$bulan_filter] ?? "Unknown" ?>)
                    <?php endif; ?>
                </h5>
                <canvas id="atkChartMinggu"></canvas>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<style>
    /* Custom CSS */
    .summary-card {
        transition: all 0.3s ease-in-out;
        border-radius: 0.75rem; /* Smoother corners */
    }
    .summary-card:hover {
        transform: translateY(-5px); 
        box-shadow: 0 10px 20px rgba(0,0,0,0.15) !important;
    }
    .chart-card {
        min-height: 400px; /* Minimum height for chart area */
    }
    #atkChart, #atkChartMinggu {
        max-height: 400px;
        width: 100% !important; 
    }
    /* Enhance alert style */
    .alert-danger {
        border-left: 5px solid #dc3545;
    }
</style>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // --- Monthly Chart ---
    const bulan  = <?= json_encode($bulan ?? []) ?>;
    const jumlah = <?= json_encode($jumlah ?? []) ?>;
    const atkList = <?= json_encode($atk_list ?? []) ?>;

    if (document.getElementById('atkChart')) {
        const ctxBulan = document.getElementById('atkChart').getContext('2d');
        new Chart(ctxBulan, {
            type: 'bar',
            data: {
                labels: bulan,
                datasets: [{
                    label: 'Office Supply Collection (Monthly)',
                    data: jumlah,
                    backgroundColor: 'rgba(25, 135, 84, 0.8)', // Success Green
                    borderColor: 'rgba(25, 135, 84, 1)',
                    borderWidth: 1,
                    borderRadius: 5, 
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false, 
                plugins: { 
                    title: { display: false },
                    legend: { display: true, position: 'top' },
                    tooltip: {
                        callbacks: {
                            // Adding ATK items to the tooltip
                            afterBody: function(context) {
                                const index = context[0].dataIndex;
                                const atk = atkList[index] || "No details available";
                                let lines = [];
                                lines.push('\nOffice Supplies:');
                                // Split items and add as new lines
                                atk.split(",").forEach(i => lines.push('- ' + i.trim()));
                                return lines;
                            }
                        }
                    }
                },
                scales: { 
                    x: { 
                        title: { display: true, text: 'Month' },
                        grid: { display: false } 
                    },
                    y: { 
                        beginAtZero: true, 
                        title: { display: true, text: 'Collection Count' },
                        ticks: { stepSize: 1 } // Ensure whole numbers for count
                    }
                },
                animation: { duration: 1000, easing: 'easeOutQuint' }
            }
        });
    }

    // --- Weekly Chart ---
    const minggu  = <?= json_encode($minggu ?? []) ?>;
    const jumlahMinggu = <?= json_encode($jumlah_minggu ?? []) ?>;

    if (document.getElementById('atkChartMinggu') && minggu.length > 0) { 
        const ctxMinggu = document.getElementById('atkChartMinggu').getContext('2d');
        new Chart(ctxMinggu, {
            type: 'line', // Changed to Line Chart for trend visualization
            data: {
                labels: minggu,
                datasets: [{
                    label: 'Office Supply Collection (Weekly)',
                    data: jumlahMinggu,
                    borderColor: 'rgba(13, 110, 253, 1)', // Primary Blue
                    backgroundColor: 'rgba(13, 110, 253, 0.1)',
                    tension: 0.4, // Smoother curve
                    fill: true, // Fill area under the line
                    pointRadius: 5,
                    pointHoverRadius: 8
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: { 
                    title: { display: false },
                    legend: { display: true, position: 'top' },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                return 'Count: ' + context.raw;
                            }
                        }
                    }
                },
                scales: { 
                    x: { title: { display: true, text: 'Week' } },
                    y: { 
                        beginAtZero: true, 
                        title: { display: true, text: 'Collection Count' },
                        ticks: { stepSize: 1 }
                    }
                },
                animation: { duration: 1200, easing: 'easeOutQuint' }
            }
        });
    }
</script>