<!DOCTYPE html>
<html>
<head>
    <title>Kalender Crew</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }

        h1 {
            text-align: center;
            margin-bottom: 20px;
            color: #333;
        }

        .calendar-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .calendar-table th, 
        .calendar-table td {
            text-align: center;
            padding: 10px;
            border: 1px solid #ddd;
        }

        .calendar-table th {
            background-color: #f8f9fa;
            font-weight: bold;
            color: #333;
        }

        .calendar-table td {
            background-color: #fff;
            vertical-align: top;
        }

        /* Warna untuk tipe absence */
        .status-A { background-color: #28a745; color: white; font-weight: bold; } /* On Site */
        .status-B { background-color: #dee2e6; color: black; font-weight: bold; } /* Pre Job */
        .status-C { background-color: #007bff; color: white; font-weight: bold; } /* Post Job */
        .status-D { background-color: #e5c19e; color: black; font-weight: bold; } /* Tool Prep */
        .status-E { background-color: #6c757d; color: white; font-weight: bold; } /* Training */

        .btn-nav {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin-bottom: 20px;
        }

        .btn-nav button {
            padding: 10px 20px;
            font-size: 16px;
            border: none;
            border-radius: 5px;
            background-color: #007bff;
            color: white;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        .btn-nav button:hover {
            background-color: #0056b3;
        }

        .absence-key {
            margin-top: 20px;
        }

        .absence-key span {
            display: inline-block;
            margin-right: 15px;
        }

        .absence-key .key {
            width: 20px;
            height: 20px;
            display: inline-block;
            margin-right: 5px;
        }
    </style>
</head>
<body>

<div class="container">
    <h1>Kalender Crew - <?= date('F Y', strtotime("$year-$month-01")) ?></h1>

    <div class="btn-nav">
        <form method="GET" action="<?= base_url('Admin/Utilization/Project_Controller/calendar_view') ?>">
            <button type="submit" name="month" value="<?= date('m', strtotime('-1 month', strtotime("$year-$month-01"))) ?>">Previous Month</button>
            <input type="hidden" name="year" value="<?= $year ?>">
        </form>
        <form method="GET" action="<?= base_url('Admin/Utilization/Project_Controller/calendar_view') ?>">
            <button type="submit" name="month" value="<?= date('m', strtotime('+1 month', strtotime("$year-$month-01"))) ?>">Next Month</button>
            <input type="hidden" name="year" value="<?= $year ?>">
        </form>
    </div>

    <table class="calendar-table table table-striped">
    <thead>
        <tr>
            <th>Employee Name</th>
            <?php for ($i = 1; $i <= $days_in_month; $i++): ?>
                <th><?= $i ?></th>
            <?php endfor; ?>
            <th>Total Days</th> <!-- Kolom Total Days -->
        </tr>
    </thead>
    <tbody>
        <?php foreach ($crew_data as $crew_name => $dates): ?>
            <tr>
                <td><strong><?= $crew_name ?></strong></td>
                <?php 
                $total_days = [
                    'A' => 0,
                    'B' => 0,
                    'C' => 0,
                    'D' => 0,
                    'E' => 0
                ];
                for ($i = 1; $i <= $days_in_month; $i++): 
                    $current_date = sprintf('%04d-%02d-%02d', $year, $month, $i);
                    $status = isset($dates[$current_date]['absence']) ? $dates[$current_date]['absence'] : '';
                    $client_name = isset($dates[$current_date]['client_name']) ? $dates[$current_date]['client_name'] : '-';

                    if ($status) {
                        $total_days[$status]++;
                    }
                ?>
                    <td class="status-<?= $status ?>">
                        <?= $status ?: '-' ?>
                        <br>
                        <small><?= $client_name ?></small>
                    </td>
                <?php endfor; ?>
                <td>
                    <strong>A:</strong> <?= $total_days['A'] ?> <br>
                    <strong>B:</strong> <?= $total_days['B'] ?> <br>
                    <strong>C:</strong> <?= $total_days['C'] ?> <br>
                    <strong>D:</strong> <?= $total_days['D'] ?> <br>
                    <strong>E:</strong> <?= $total_days['E'] ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>


    <div class="absence-key">
        <span><div class="key status-A"></div> On Site</span>
        <span><div class="key status-B"></div> Pre Job</span>
        <span><div class="key status-C"></div> Post Job</span>
        <span><div class="key status-D"></div> Tool Prep</span>
        <span><div class="key status-E"></div> Training</span>
    </div>
</div>

<!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script> -->
</body>
</html>
