<?php $this->load->view('Admin/head'); ?>

<div class="container-fluid pt-4">
    <div class="row">
        <!-- Card Total Inventory -->
        <div class="col-sm-6 col-xl-4">
            <div class="bg-light rounded d-flex align-items-center justify-content-between p-4 hover-shadow">
                <i class="fa fa-box fa-3x text-primary"></i>
                <div class="ms-3">
                    <p class="mb-2 text-dark">Total Inventory yang tersedia</p>
                    <h6 class="mb-0 text-dark"><?= $total_inventory ?></h6>
                </div>
            </div>
        </div>
    </div>

    <!-- Chart Pengambilan ATK -->
    <div class="container mt-4">
        <h4>Diagram Pengambilan ATK Per Bulan</h4>
        <canvas id="atkChart" height="100"></canvas>
    </div>

    <!-- Optional: Table Inventory / Ringkasan -->
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const bulan = <?= json_encode($bulan) ?>;
    const jumlah = <?= json_encode($jumlah) ?>;

    const ctx = document.getElementById('atkChart').getContext('2d');
    new Chart(ctx, {
        type: 'bar',
        data: {
            labels: bulan,
            datasets: [{
                label: 'Jumlah Pengambilan',
                data: jumlah,
                backgroundColor: 'rgba(54, 162, 235, 0.7)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1,
                borderRadius: 5
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: { display: false },
                title: {
                    display: true,
                    text: 'Pengambilan ATK Per Bulan'
                }
            },
            scales: {
                y: { beginAtZero: true, ticks: { stepSize: 5 } }
            }
        }
    });
</script>

<?php $this->load->view('Admin/footer'); ?>
