<!DOCTYPE html>
<html>
<head>
    <title>Rekap Pengambilan ATK</title>
    <style>
        /* Menggunakan font yang aman untuk PDF */
        body { 
            font-family: DejaVu Sans, sans-serif; 
            font-size: 10pt; /* Ukuran font lebih standar untuk dokumen */
            margin: 30px; /* Margin halaman */
        }
        
        /* --- HEADER STYLES --- */
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header h3 {
            margin: 5px 0 10px 0;
            font-size: 16pt;
            color: #333;
        }
        .header .subtitle {
            font-size: 10pt;
            color: #666;
        }
        .date-info {
            text-align: right;
            font-size: 9pt;
            margin-bottom: 10px;
        }

        /* --- TABLE STYLES --- */
        table { 
            width: 100%; 
            border-collapse: collapse; 
            margin-top: 10px; 
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        th, td { 
            border: 1px solid #ddd; /* Warna border lebih lembut */
            padding: 8px 12px; /* Padding lebih nyaman */
        }
        th { 
            background-color: #007bff; /* Warna biru untuk header */
            color: white;
            text-transform: uppercase;
            font-size: 10pt;
            font-weight: bold;
        }
        
        /* Alignment data yang spesifik */
        .text-left { text-align: left; }
        .text-center { text-align: center; }
        .text-right { text-align: right; }
        
        /* Alignment untuk kolom tertentu */
        table tbody td:nth-child(1) { width: 5%; text-align: center; } /* No */
        table tbody td:nth-child(2) { text-align: left; } /* Nama Peminjam */
        table tbody td:nth-child(3) { text-align: left; } /* Divisi */
        table tbody td:nth-child(4) { text-align: right; } /* Total Transaksi */
        table tbody td:nth-child(5) { text-align: right; } /* Total Item */

        /* Garis pemisah antar baris */
        table tbody tr:nth-child(even) { 
            background-color: #f9f9f9; 
        }
    </style>
</head>
<body>

    <div class="header">
        <div class="date-info">
            Dicetak pada: <?= date('d F Y H:i:s') ?>
        </div>
        <h3>REKAPITULASI PENGAMBILAN ATK</h3>
        <p class="subtitle">Berdasarkan Peminjam dan Divisi</p>
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 5%;">No.</th>
                <th>Nama Peminjam</th>
                <th>Divisi</th>
                <th style="width: 15%;">Total Transaksi</th>
                <th style="width: 15%;">Total Item</th>
            </tr>
        </thead>
        <tbody>
            <?php if(!empty($rekap)): $no=1; foreach($rekap as $r): ?>
                <tr>
                    <td><?= $no++ ?></td>
                    <td><?= $r->atk_pengambilan_peminjam ?></td>
                    <td><?= $r->atk_pengambilan_divisi ?></td>
                    <td class="text-right"><?= $r->total_transaksi ?></td>
                    <td class="text-right"><?= $r->total_item ?></td>
                </tr>
            <?php endforeach; else: ?>
                <tr>
                    <td colspan="5" class="text-center">Belum ada data rekapitulasi.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</body>
</html>