<div class="container-fluid pt-4 px-4">

    <div class="card mb-4 border-0 shadow-lg bg-light">
        <div class="card-header bg-primary text-white d-flex align-items-center">
            <i class="fas fa-search me-2"></i>
            <h5 class="mb-0">Filter Inventaris</h5>
        </div>
        <div class="card-body">
            <form method="get" action="<?= site_url('Admin/Inventory/Inventory_Controller/dashboard') ?>" class="row g-3">
                
                <div class="col-md-5">
                    <label for="filter_kategori" class="form-label fw-bold text-primary">Kategori</label>
                    <select name="filter_kategori" id="filter_kategori" class="form-select form-select-lg border-primary">
                        <option value="">-- Semua Kategori --</option>
                        <?php foreach($categories as $cat): ?>
                            <option value="<?= $cat->atk_categories_id ?>" 
                                <?= ($this->input->get('filter_kategori') == $cat->atk_categories_id) ? 'selected' : '' ?>>
                                <?= htmlspecialchars($cat->atk_categories_nama) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="col-md-5">
                    <label for="filter_lokasi" class="form-label fw-bold text-primary">Lokasi Penyimpanan</label>
                    <select name="filter_lokasi" id="filter_lokasi" class="form-select form-select-lg border-primary">
                        <option value="">-- Semua Lokasi --</option>
                        <?php foreach($locations as $loc): ?>
                            <option value="<?= $loc->inventory_location_id ?>" 
                                <?= ($this->input->get('filter_lokasi') == $loc->inventory_location_id) ? 'selected' : '' ?>>
                                <?= htmlspecialchars($loc->inventory_location_nama) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="col-md-2 d-flex align-items-end justify-content-end">
                    <button type="submit" class="btn btn-primary btn-lg me-2 flex-grow-1">
                        <i class="fas fa-filter me-1"></i> Filter
                    </button>
                    <a href="<?= site_url('Admin/Inventory/Inventory_Controller/dashboard') ?>" class="btn btn-outline-secondary btn-lg flex-grow-1">
                        <i class="fas fa-sync-alt me-1"></i> Reset
                    </a>
                </div>

            </form>
        </div>
    </div>

    <hr class="my-4">

    <h4 class="mb-3 text-dark"><i class="fas fa-boxes me-2"></i>Daftar Produk Inventaris</h4>
    <div class="row g-4">
        <?php if(!empty($product)): ?>
            <?php foreach($product as $row): ?>
                <div class="col-sm-6 col-md-4 col-lg-3">
                    <a href="<?= site_url('admin/inventory/detail/'.$row->atk_product_id) ?>" class="text-decoration-none h-100 d-block">
                        <div class="card product-card h-100 shadow-sm border-2 border-primary-subtle">
                            <div class="card-body d-flex flex-column">
                                <div class="d-flex align-items-start mb-3">
                                    <i class="fas fa-box-open fa-3x text-info me-3"></i>
                                    <div class="flex-grow-1">
                                        <h5 class="fw-bolder text-dark mb-1 text-truncate" title="<?= htmlspecialchars($row->atk_product_nama) ?>">
                                            <?= htmlspecialchars($row->atk_product_nama) ?>
                                        </h5>
                                        <span class="badge rounded-pill bg-secondary mb-2"><?= htmlspecialchars($row->inventory_location_nama) ?></span>
                                    </div>
                                </div>
                                
                                <div class="mt-auto pt-2 border-top">
                                    <p class="text-muted small mb-1">Stok Tersedia:</p>
                                    <?php if ($row->atk_product_stok == 0): ?>
                                        <h4 class="fw-bold text-danger">
                                            <i class="fas fa-times-circle"></i> Stok Kosong
                                        </h4>
                                    <?php elseif ($row->atk_product_stok < 5): ?>
                                        <h4 class="fw-bold text-warning">
                                            <i class="fas fa-exclamation-triangle"></i> <?= htmlspecialchars($row->atk_product_stok) ?> <?= htmlspecialchars($row->uom_categories_nama) ?>
                                        </h4>
                                        <small class="text-danger fw-semibold">(Hampir Habis!) </small>
                                    <?php else: ?>
                                        <h4 class="fw-bold text-success">
                                            <i class="fas fa-check-circle"></i> <?= htmlspecialchars($row->atk_product_stok) ?> <?= htmlspecialchars($row->uom_categories_nama) ?>
                                        </h4>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="col-12">
                <div class="alert alert-info text-center py-4 border-0 shadow-sm">
                    <h4 class="alert-heading"><i class="fas fa-info-circle me-2"></i>Tidak Ada Produk Ditemukan</h4>
                    <p class="mb-0">Coba atur ulang filter Anda atau tambahkan produk baru.</p>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
/* CSS Kustom */
.product-card {
    cursor: pointer;
    transition: all 0.3s ease-in-out;
    border-radius: 0.75rem; /* Sudut lebih melengkung */
}

.product-card:hover {
    transform: translateY(-8px); /* Efek melayang lebih tinggi */
    box-shadow: 0 15px 30px rgba(0,0,0,0.2) !important; /* Bayangan lebih jelas */
    border-color: var(--bs-primary) !important; /* Menyorot batas kartu saat hover */
}

.card-header h5 {
    font-size: 1.25rem;
}

.form-select-lg {
    min-height: calc(2.25rem + 1rem + 2px); /* Menyelaraskan dengan tombol lg */
}

/* Badge untuk lokasi di card produk */
.product-card .badge {
    font-size: 0.75rem;
    padding: 0.5em 0.75em;
}

/* Text truncate untuk nama produk panjang */
.text-truncate {
    display: block;
    max-width: 100%;
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
}
</style>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">