/*!
 * node-sass: lib/errors.js
 */

var sass = require('./extensions'),
  pkg = require('../package.json');

function humanEnvironment() {
  return sass.getHumanEnvironment(sass.getBinaryName());
}

function foundBinaries() {
  return [
    'Found bindings for the following environments:',
    foundBinariesList(),
  ].join('\n');
}

function foundBinariesList() {
  return sass.getInstalledBinaries().map(function(env) {
    return '  - ' + sass.getHumanEnvironment(env);
  }).join('\n');
}

function missingBinaryFooter() {
  return [
    'This usually happens because your environment has changed since running `npm install`.',
    'Run `npm rebuild node-sass` to build the binding for your current environment.',
  ].join('\n');
}

module.exports.unsupportedEnvironment = function() {
  return [
    'Node Sass does not yet support your current environment: ' + humanEnvironment(),
    'For more information on which environments are supported please see:',
    'https://github.com/sass/node-sass/releases/tag/v' + pkg.version
  ].join('\n');
};

module.exports.missingBinary = function() {
  return [
    'Missing binding ' + sass.getBinaryPath(),
    'Node Sass could not find a binding for your current environment: ' + humanEnvironment(),
    '',
    foundBinaries(),
    '',
    missingBinaryFooter(),
  ].join('\n');
};
