<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Atk_Product_Controller extends CI_Controller {

    public function __construct(){
		parent::__construct();
		$this->load->model("ATK_Product_model");
        $this->load->model("ATK_Categories_model");
        $this->load->model("Location_model");
        $this->load->model("Inventory_Types_model");
        $this->load->model("Brand_Categories_model");
        $this->load->model("Uom_Categories_model");
		$this->load->library('session');
	}

	

    public function index()
    {
        // Ambil filter kategori dari GET, jika ada
        $filter_kategori = $this->input->get('filter_kategori');


        $filter_lokasi = $this->input->get('filter_lokasi');


        // Ambil semua data ATK Product dengan filter kategori (jika diterapkan)
        $data["product"] = $this->ATK_Product_model->getAll($filter_kategori, $filter_lokasi);
        $data["kategori"] = $this->ATK_Categories_model->getAll();
        $data["location"] = $this->Location_model->getAll();
        $data["type"] = $this->Inventory_Types_model->getAll();
        $data["brand"] = $this->Brand_Categories_model->getAll();
        $data["uom"] = $this->Uom_Categories_model->getAll();

        // Sertakan filter untuk menjaga state dropdown kategori
        $data['filter_kategori'] = $filter_kategori;
        $data['filter_lokasi'] = $filter_lokasi;


        // Memuat view
        $this->load->view('Admin/head');
        $this->load->view('Admin/Atk_Product/view', $data);
        $this->load->view('Admin/Atk_Product/add', $data);
        $this->load->view('Admin/footer');
    }

    public function export_excel()
    {
        // Ambil filter kategori dan lokasi dari GET, jika ada
        $filter_kategori = $this->input->get('filter_kategori');
        $filter_lokasi = $this->input->get('filter_lokasi');

        

        // Ambil data yang sudah difilter
        $data['product'] = $this->ATK_Product_model->getAll($filter_kategori, $filter_lokasi);

        // Panggil fungsi generate_excel
        $this->generate_excel($data);
    }

    private function generate_excel($data)
    {
        // Pastikan Anda sudah mengimpor autoload.php
        require_once 'vendor/autoload.php';

        // Load library PhpSpreadsheet
        $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        // Path untuk logo Asiaserv
        $logoPath = 'assets/img/asiaserv-logo.png'; // Pastikan path ini sesuai dengan lokasi logo Anda

        // Menambahkan gambar (logo Asiaserv) ke spreadsheet
        $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
        $drawing->setName('Asiaserv Logo');
        $drawing->setDescription('Asiaserv Logo');
        $drawing->setPath($logoPath);
        $drawing->setHeight(100); // Set tinggi gambar sesuai keinginan
        $drawing->setCoordinates('A1'); // Set posisi gambar (misalnya di A1)
        $drawing->setWorksheet($sheet);

        // Set Title & Header
        $sheet->setCellValue('A3', 'Laporan Data ATK');
        $sheet->setCellValue('A4', 'PT Asiaserv Indonesia');
        $sheet->mergeCells('A3:H3');
        $sheet->mergeCells('A4:H4');

        // Formatting Title
        $sheet->getStyle('A3:H3')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle('A3:H3')->getFont()->setBold(true)->setSize(14);

        // Formatting Sub-Title
        $sheet->getStyle('A4:H4')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle('A4:H4')->getFont()->setBold(true)->setSize(12);

        // Set Table Header on row 7
        $sheet->setCellValue('A7', 'No');
        $sheet->setCellValue('B7', 'Nama ATK');
        $sheet->setCellValue('C7', 'Brand');
        $sheet->setCellValue('D7', 'Kategori');
        $sheet->setCellValue('E7', 'Stok');
        $sheet->setCellValue('F7', 'Satuan');
        $sheet->setCellValue('G7', 'Lokasi');
        $sheet->setCellValue('H7', 'Notes');

        // Styling Table Header
        $sheet->getStyle('A7:H7')->getFont()->setBold(true);
        $sheet->getStyle('A7:H7')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle('A7:H7')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()->setRGB('D9EAD3');  // Light green background for header

        // Add border to the header cells
        $sheet->getStyle('A7:H7')->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);

        // Add data for ATK Product
        $row = 8;
        $no = 1; // Counter for No column
        foreach ($data['product'] as $product) {
            $sheet->setCellValue('A' . $row, $no); // Numbering
            $sheet->setCellValue('B' . $row, $product->atk_product_nama);
            $sheet->setCellValue('C' . $row, $product->brand_categories_nama);
            $sheet->setCellValue('D' . $row, $product->atk_categories_nama);
            $sheet->setCellValue('E' . $row, $product->atk_product_stok);
            $sheet->setCellValue('F' . $row, $product->uom_categories_nama);
            $sheet->setCellValue('G' . $row, $product->inventory_location_nama);
            $sheet->setCellValue('H' . $row, $product->atk_product_notes);

            // Add borders for each data row
            $sheet->getStyle('A' . $row . ':H' . $row)->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);

            $row++;
            $no++; // Increment number for next row
        }

        // Auto-size columns to fit content
        foreach (range('A', 'H') as $col) {
            $sheet->getColumnDimension($col)->setAutoSize(true);
        }

        // Export to Excel
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="Data_ATK.xlsx"');
        header('Cache-Control: max-age=0');
        $writer->save('php://output');
        exit;
    }








    public function input()
	{
		// $x['idKategori']=$this->kategori_model->autoId();
		$this->load->view('Admin/head');
		$this->load->view('Admin/Atk_Product/add');
		$this->load->view('Admin/footer');
	}

	
    public function tambah(){
    $inventory = $this->ATK_Product_model;
    // otomatis update_date diisi di model
    $result = $inventory->save();
    if($result > 0) $this->sukses();
    else $this->gagal();	
}


	function sukses(){
        $this->session->set_flashdata('pesan_success', 'Data Product ATK berhasil dibuat');
        redirect('Admin/ATK/Atk_Product_Controller');
	}

	function gagal(){
        $this->session->set_flashdata('pesan_error', 'Data Location berhasil dibuat');
        redirect('Admin/ATK/Atk_Product_Controller');
	}


    // public function view_ubah($atk_product_id) {
    //     $where = array('atk_product_id' => $atk_product_id);
    //     $data['inventory'] = $this->ATK_Product_model->view_update($where, 'inventory')->row(); // Use row() for a single object
    //     $this->load->view('Admin/head');
    //     $this->load->view('Admin/Inventory/update', $data);
    //     $this->load->view('Admin/footer');
    // }

    public function view_ubah($atk_product_id) {
        $where = array('atk_product_id' => $atk_product_id);
        $data['product'] = $this->ATK_Product_model->view_update($where, 'atk_product')->row();
        $data['locations'] = $this->Location_model->getAll(); // untuk lokasi
        $data['types'] = $this->Inventory_Types_model->getAll(); // untuk tipe
        $data['brand']=$this->Brand_Categories_model->getAll();
        $data['uom']=$this->Uom_Categories_model->getAll();
        $data["kategori"]=$this->ATK_Categories_model->getAll();
        $this->load->view('Admin/head');
        $this->load->view('Admin/Atk_Product/update', $data);
        $this->load->view('Admin/footer');
    }
    
    

    // Simpan Ubah ke Database
    public function update(){

        date_default_timezone_set("Asia/Jakarta");
        $tanggal = date("Y-m-d H:i:s");

		$post = $this->input->post();	
		$atk_product_id 		= $this->input->post('atk_product_id');
        $atk_product_nama = $this->input->post('atk_product_nama');
        $atk_product_stok = $this->input->post('atk_product_stok');
        $atk_product_uom = $this->input->post('atk_product_uom');
        $atk_product_inventory_types = $this->input->post('atk_product_inventory_types');
        $atk_product_categories = $this->input->post('atk_product_categories');
        $atk_product_brand = $this->input->post('atk_product_brand');
        $atk_product_location = $this->input->post('atk_product_location');
        $atk_product_notes = $this->input->post('atk_product_notes');
        // $atk_product_status = $this->input->post('atk_product_status');
        // $updated_at = $tanggal;

   

        $data = array(
			'atk_product_id'         => $atk_product_id,
			'atk_product_nama'       => $atk_product_nama,
            'atk_product_stok'       => $atk_product_stok,
            'atk_product_uom'       => $atk_product_uom,
            'atk_product_inventory_types'       => 9,
            'atk_product_categories'       => $atk_product_categories,
            'atk_product_brand'       => $atk_product_brand,
            'atk_product_location'       => $atk_product_location,
            'atk_product_notes'       => $atk_product_notes,
            'atk_product_status'       => 1,
            'update_date' => date("Y-m-d H:i:s")
           
        );

        $where = array(
            'atk_product_id'       => $atk_product_id
        );

        $this->ATK_Product_model->update($where,$data,'atk_product');
        $this->session->set_flashdata('pesan_success', 'Data Product ATK berhasil diubah');
        redirect('Admin/ATK/Atk_Product_Controller');
    }

	public function hapus($atk_product_id){
		$data = array(
            'atk_product_id'       => $atk_product_id,
            'atk_product_status'        => 0
        );

        $where = array(
            'atk_product_id'       => $atk_product_id
        );
        $this->ATK_Product_model->update($where,$data,'atk_product');
        $this->session->set_flashdata('pesan_success', 'Data Product ATK berhasil dihapus');
        redirect('Admin/ATK/Atk_Product_Controller');
    }
public function export_pdf()
{
    $filter_kategori = $this->input->get('filter_kategori');
    $filter_lokasi   = $this->input->get('filter_lokasi');

    // Ambil data sesuai filter
    $data = $this->ATK_Product_model->getFiltered($filter_kategori, $filter_lokasi);

    // Load library PDF (FPDF)
    $this->load->library('pdf');
    $pdf = new Pdf('L','mm','A4');
    $pdf->AddPage();
    $pdf->SetFont('Arial','B',10);

    // Header tabel
    $pdf->Cell(10,10,'No',1,0,'C');
    $pdf->Cell(40,10,'ATK Name',1,0,'C');
    $pdf->Cell(30,10,'Brand',1,0,'C');
    $pdf->Cell(30,10,'Category',1,0,'C');
    $pdf->Cell(20,10,'Inventory',1,0,'C');
    $pdf->Cell(20,10,'Unit',1,0,'C');
    $pdf->Cell(40,10,'Location',1,0,'C');
    $pdf->Cell(50,10,'Notes',1,0,'C');
    $pdf->Cell(30,10,'Update Date',1,1,'C');

    $pdf->SetFont('Arial','',9);
    $no = 1;
    foreach ($data as $row) {
        $pdf->Cell(10,7,$no++,1,0,'C');
        $pdf->Cell(40,7,$row->atk_product_nama,1,0);
        $pdf->Cell(30,7,$row->brand_categories_nama,1,0);
        $pdf->Cell(30,7,$row->atk_categories_nama,1,0);
        $pdf->Cell(20,7,$row->atk_product_stok,1,0,'C');
        $pdf->Cell(20,7,$row->uom_categories_nama,1,0,'C');
        $pdf->Cell(40,7,$row->inventory_location_nama,1,0);
        $pdf->Cell(50,7,$row->atk_product_notes,1,0);
        $pdf->Cell(30,7,date("d-m-Y H:i", strtotime($row->update_date)),1,1);
    }

    $pdf->Output('D', 'data_atk.pdf');
}

  
    
}
?>