<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Uom_Categories_Controller extends CI_Controller {

    public function __construct(){
		parent::__construct();
		$this->load->model("Uom_Categories_model");
		$this->load->library('session');
	}

	public function index()
	{
		$data["uom"]=$this->Uom_Categories_model->getAll();
	    $this->load->view('Admin/head');
	    $this->load->view('Admin/Uom/view',$data);
        $this->load->view('Admin/Uom/add',$data);
		$this->load->view('Admin/footer');
	}

    public function input()
	{
		// $x['idKategori']=$this->kategori_model->autoId();
		$this->load->view('Admin/head');
		$this->load->view('Admin/Uom/add');
		$this->load->view('Admin/footer');
	}

	
    public function tambah(){
		$uom = $this->Uom_Categories_model;
		$result =$uom->save();
		if($result > 0) $this->sukses();
		else $this->gagal();	
		
	}

	function sukses(){
        $this->session->set_flashdata('pesan_success', 'Data uom berhasil dibuat');
        redirect('Admin/Option/uom_Categories_Controller');
	}

	function gagal(){
        $this->session->set_flashdata('pesan_error', 'Data uom gagal dibuat');
        redirect('Admin/Option/uom_Categories_Controller');
	}


    public function view_ubah($uom_categories_id) {
        $where = array('uom_categories_id' => $uom_categories_id);
        $data['uom'] = $this->Uom_Categories_model->view_update($where, 'uom_categories')->row(); // Use row() for a single object
        $this->load->view('Admin/head');
        $this->load->view('Admin/Uom/update', $data);
        $this->load->view('Admin/footer');
    }
    

    // Simpan Ubah ke Database
    public function update(){

		$post = $this->input->post();	
		$uom_categories_id 		= $this->input->post('uom_categories_id');
        $uom_categories_nama	= $this->input->post('uom_categories_nama');
   

        $data = array(
			'uom_categories_id'         => $uom_categories_id,
			'uom_categories_nama'       => $uom_categories_nama,
			'uom_categories_status'     => 1
        );

        $where = array(
            'uom_categories_id'       => $uom_categories_id
        );

        $this->Uom_Categories_model->update($where,$data,'uom_categories');
        $this->session->set_flashdata('pesan_success', 'Data uom Berhasil diubah');
        redirect('Admin/Option/uom_Categories_Controller');
    }

	public function hapus($uom_categories_id){
		$data = array(
            'uom_categories_id'       => $uom_categories_id,
            'uom_categories_status'        => 0
        );

        $where = array(
            'uom_categories_id'       => $inveuom_categories_idntory_Type_id
        );
        $this->Uom_Categories_model->update($where,$data,'uom_categories');
        $this->session->set_flashdata('pesan_success', 'Data uom berhasil dihapus');
        redirect('Admin/Option/uom_Categories_Controller');
    }

    
}
?>