<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Login extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model("Akun_model");
        $this->load->library('form_validation');
        $this->load->helper('url');

        // Cek login dan timeout, kecuali method index/ceklogin/logout
        $excluded = ['index', 'ceklogin', 'logout'];
        $current_method = $this->router->fetch_method();

        if (!in_array($current_method, $excluded)) {
            // Jika tidak login, arahkan ke login
            if (!$this->session->userdata('user_id')) {
                $this->session->set_flashdata('pesan_error', 'Sesi Anda telah habis, silakan login kembali.');
                redirect('Auth/Login');
            }
            // Cek timeout otomatis
            $this->check_timeout();
        }
    }

    private function check_timeout() {
        $inactive = 1800; // 30 menit
        if ($this->session->userdata('last_activity')) {
            $session_life = time() - $this->session->userdata('last_activity');
            if ($session_life > $inactive) {
                $this->session->sess_destroy();
                $this->session->set_flashdata('pesan_error', 'Sesi habis karena 30 menit tidak aktif.');
                redirect('Auth/Login');
            }
        }
        $this->session->set_userdata('last_activity', time());
    }

    public function index()
    {
        $this->load->view('login');
    }

    public function ceklogin()
{
    $this->form_validation->set_rules('username', 'Username', 'required');
    $this->form_validation->set_rules('pass', 'Password', 'required');
    $this->form_validation->set_message('required', "%s tidak boleh kosong.");

    if ($this->form_validation->run() == TRUE) {
        $post = $this->input->post();
        if (isset($post["username"]) && isset($post["pass"])) {
            $data = $this->Akun_model->getByUsernamePassword();

            if ($data != null) {
                // set session termasuk flag logged_in
                $newdata = array(
                    'user_id'       => $data->id_akun,
                    'user_username' => $data->username,
                    'user_nama'     => $data->nama_user,
                    'user_role'     => $data->role,
                    'user_profile'  => $data->foto_profile,
                    'last_activity' => time(),
                    'logged_in'     => true
                );
                $this->session->set_userdata($newdata);

                $this->session->set_flashdata('pesan_success', 'Selamat Datang di Asset Management !');
               

                // gunakan redirect ke route friendly, jangan pakai base_url() di redirect()
                if (strtolower($data->role) == "admin") {
                    redirect('admin/dashboard');
                } else {
                    redirect('user/dashboard');
                }
            } else {
                $this->session->set_flashdata('pesan_error', 'Username atau Password tidak terdaftar!');
                redirect('Auth/Login');
            }
        } else {
            $this->session->set_flashdata('pesan_error', 'Username atau Password tidak boleh kosong!');
            redirect('Auth/Login');
        }
    } else {
        $this->load->view('login');
    }
}


    // Logout manual
    public function logout()
    {
        $this->session->sess_destroy();
        redirect('Auth/Login');
    }
}
