<?php
require(APPPATH . '/third_party/fpdf184/fpdf.php');

class Pdf extends FPDF {
    function __construct($orientation = 'L', $unit = 'mm', $size = 'A4') {
        parent::__construct($orientation, $unit, $size); // ✅ Default Landscape
    }

    // Header kustom
    function Header() {
        // Pastikan path ke logo benar
        $logoPath = FCPATH . 'assets/img/asiaserv-logo.png';

        if (file_exists($logoPath)) {
            $this->Image($logoPath, 10, 6, 30); // x=10, y=6, lebar=30 mm
        } else {
            $this->SetFont('Arial','B',12);
            $this->Cell(0,10,'ASIASERV Asset Management',0,1,'C');
        }

        // Judul
        $this->SetFont('Arial','B',14);
        $this->Cell(0,10,'LAPORAN PENGAMBILAN ATK',0,1,'C');
        $this->Ln(10);
    }

    // Footer kustom
    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'Halaman ' . $this->PageNo(), 0, 0, 'C');
    }
    
}
