<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Inventory_model extends CI_Model
{
    private $_table = "inventory";

    public function __construct() {
        parent::__construct();
    }

    // Ambil semua inventory + join lokasi & tipe
    public function getAll() {
        $this->db->select('inventory.*, inventory_location.inventory_location_nama, inventory_types.inventory_types_nama');
        $this->db->from('inventory');
        $this->db->join('inventory_location', 'inventory.inventory_location_id = inventory_location.inventory_location_id', 'left');
        $this->db->join('inventory_types', 'inventory.inventory_types_id = inventory_types.inventory_types_id', 'left');
        $query = $this->db->get();
        return $query->result();
    }

// Hitung total semua qty inventory
    public function jumlah_inventory()
{
    $this->db->select_sum('inventory_qty');
    ///$this->db->where('inventory_status', 1);
    $query = $this->db->get('inventory');
    return $query->row()->inventory_qty ?? 0;
}



    // Tambah data inventory
    public function save()
    {
        date_default_timezone_set("Asia/Jakarta");
        $tanggal = date("Y-m-d H:i:s");

        $post = $this->input->post();
        $this->inventory_nama = $post["inventory_nama"];
        $this->inventory_SN = $post["inventory_SN"];
        $this->inventory_location_id = $post["inventory_location_id"];
        $this->inventory_types_id = $post["inventory_types_id"];
        $this->inventory_remarks = $post["inventory_remarks"];
        $this->inventory_price = $post["inventory_price"];
        $this->inventory_material = $post["inventory_material"];
        $this->inventory_qty = $post["inventory_qty"];
        $this->inventory_status = "1";
        $this->created_at =  $tanggal;
        $this->created_by = $post["created_by"];  
        return $this->db->insert($this->_table, $this);
    }

    public function view_update($where, $table){
        return $this->db->get_where($table, $where);
    }

    public function update($where, $data, $table){
        $this->db->where($where);
        $this->db->update($table, $data);
    }

    public function delete($where, $table){
        $this->db->where($where);
        $this->db->delete($table);
    }

    public function get_inventory_by_produk()
{
    return $this->db->select('id_produk, nama_produk, COUNT(*) as jumlah, SUM(stok) as total_stok')
                    ->from('inventory')
                    ->group_by('id_produk, nama_produk')
                    ->get()
                    ->result();
}

public function get_produk_detail($id_produk)
{
    return $this->db->where('id_produk', $id_produk)
                    ->get('inventory')
                    ->result();
}

public function jumlah_inventory_per_produk()
{
    $this->db->select('p.atk_product_nama, SUM(p.atk_product_stok) as total, u.uom_categories_nama');
    $this->db->from('atk_product p');
    $this->db->join('uom_categories u', 'p.atk_product_uom = u.uom_categories_id', 'left');
    $this->db->group_by('p.atk_product_nama, u.uom_categories_nama');
    return $this->db->get()->result();
}




    public function get_by_nama($nama)
{
    $this->db->select('i.*, l.location_name, t.types_name');
    $this->db->from('inventory i');
    $this->db->join('location l', 'i.inventory_location_id = l.location_id', 'left');
    $this->db->join('inventory_types t', 'i.inventory_types_id = t.types_id', 'left');
    $this->db->where('i.inventory_nama', $nama);
    $this->db->where('i.inventory_status', 1);
    return $this->db->get()->result();
}



}
