<div class="container-fluid pt-4 px-4">
    <div class="card shadow mb-4">
        <div class="card-header py-3 ">
            <h6 class="m-0 font-weight-bold text-primary">Master User
            <span style="float: right">
            <a href="<?php echo site_url('Admin/Akun/masteruser/input') ?>" class ="btn btn-success btn-sm float-right">Add Date</a>
            </span>
        </h6>         
        </div>
        <div class="card-body">
            <div id="flash" data-flash="<?=$this->session->flashdata('pesan_success'); ?>"></div> 
            <?php
                if ($this->session->flashdata('pesan_error')) {
                    echo '<div class="alert alert-danger alert-dismissible bg-danger text-white border-0 fade show" role="alert">
                            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>';
                    echo $this->session->flashdata('pesan_error');
                    echo '</div>';
                }
            ?>

            <!-- Filter Role -->
            <div class="mb-3">
                <label for="filterRole" class="form-label">Filter Role:</label>
                <select id="filterRole" class="form-select" onchange="filterTable()">
                    <option value="">All Role</option>
                    <option value="User">User</option>
                    <option value="Admin">Admin</option>
                    <option value="Manager">Manager</option>
                    <option value="PC">Project Coordinator</option>
                    <option value="Workshop">Workshop</option>
                    <option value="Crew">Crew</option>
                </select>
            </div>

            <div class="table-responsive">
                <table class = "table table-bordered table-hover table-striped" id="datatables">
                    <thead>
                        <tr>
                            <th>No.</th>
                            <!-- <th>Id User</th> -->
                            <th>Name</th>
                            <th>Role</th>
                            <th>Email</th>
                            <th class="text-center">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $i = 0; ?>
                        <?php foreach ($user as $u) { ?>
                            <tr>
                                <td>
                                    <?php $i++; ?>
                                    <?php echo $i ?>
                                </td>
                                <!-- <td><?php echo $u->id_akun ?></td> -->
                                <td><?php echo $u->nama_user ?></td>     
                                <td>
                                    <?php 
                                        if($u->role == "User" || $u->role == "user") { 
                                                echo '<span class="badge bg-success">user</span>';
                                        } 
                                        else if($u->role == "Admin" || $u->role == "admin") { 
                                                echo '<span class="badge bg-secondary">admin</span>';
                                        } 
                                        else if($u->role == "Manager" || $u->role == "Manager") { 
                                                echo '<span class="badge bg-warning">Manager</span>';
                                        } 
                                        else if($u->role == "PC" || $u->role == "PC") { 
                                                echo '<span class="badge bg-info">Project Coordinator</span>';
                                        }
                                        else if($u->role == "Workshop" || $u->role == "Workshop") { 
                                                echo '<span class="badge bg-primary">Workshop</span>';
                                        }
                                        else if($u->role == "Crew" || $u->role == "crew") { 
                                            echo '<span class="badge bg-dark">Crew</span>';
                                        }
                                    ?>
                                </td>
                                <td><?php echo $u->email ?></td>

                                <td class="text-center">
                                    <a href="<?= base_url('Admin/Akun/masteruser/view_detail/'.$u->id_akun) ?>" class="btn btn-info btn-sm"><i class="fa fa-eye"></i></a>
                                    <a href="<?= base_url('Admin/Akun/masteruser/view_ubah/'.$u->id_akun) ?>" class="btn btn-warning btn-sm"><i class="fa fa-edit"></i></a>
                                    <a href="<?= base_url('Admin/Akun/masteruser/hapus/'.$u->id_akun) ?>" class="btn btn-danger btn-sm" id="tombol-hapus">   
                                        <i class="fa fa-trash"></i> 
                                    </a>                                    
                                </td>
                            </tr>
                        <?php 
                        } ?>
                    </tbody>
                </table>        
            </div>  
        </div>
    </div>
</div>

<script>
function filterTable() {
    var filterValue = document.getElementById("filterRole").value.toLowerCase();
    var table = document.getElementById("datatables");
    var rows = table.getElementsByTagName("tr");

    for (var i = 1; i < rows.length; i++) { // Start from 1 to skip the header row
        var roleCell = rows[i].getElementsByTagName("td")[2];
        if (roleCell) {
            var roleText = roleCell.textContent || roleCell.innerText;
            if (filterValue === "" || roleText.toLowerCase().includes(filterValue)) {
                rows[i].style.display = "";
            } else {
                rows[i].style.display = "none";
            }
        } 
    }
}
</script>
