<!-- Modal Form untuk Tambah Pengambilan ATK -->
<div class="modal fade" id="InventoryModal" tabindex="-1" aria-labelledby="InventoryModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            
            <!-- Modal Header -->
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="InventoryModalLabel">
                    <i class="fas fa-box-open"></i> ATK Requisition Form
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            
            <!-- Modal Body -->
            <div class="modal-body">
                <form action="<?= base_url('Admin/ATK/Atk_Pengambilan_Controller/tambah'); ?>" method="post">

                    <!-- Nama Peminjam -->
                    <div class="mb-4">
                        <label for="atk_pengambilan_peminjam" class="form-label">Full Name</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-user"></i></span>
                            <input type="text" class="form-control" id="atk_pengambilan_peminjam" 
                                 name="atk_pengambilan_peminjam" placeholder="Masukkan Nama" required>
                        </div>
                    </div>

                    <!-- Divisi -->
                    <div class="mb-4">
                        <label for="atk_pengambilan_divisi" class="form-label">Division of Origin</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-building"></i></span>
                            <select class="form-control" id="atk_pengambilan_divisi" 
                                    name="atk_pengambilan_divisi" required>
                                <option value="">-- Select Division --</option>
                                <?php foreach ($divisi as $inventory): ?>
                                    <option value="<?= $inventory->divisi_categories_id; ?>"
                                        <?= set_select('atk_pengambilan_divisi', $inventory->divisi_categories_id); ?>>
                                        <?= $inventory->divisi_categories_nama; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <!-- Lokasi -->
                    <div class="mb-4">
                        <label for="atk_pengambilan_lokasi" class="form-label">Location</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-map-marker-alt"></i></span>
                            <select class="form-control" id="atk_pengambilan_lokasi" 
                                    name="atk_pengambilan_lokasi" required>
                                <option value="">-- Select Location --</option>
                                <?php foreach ($lokasi as $loc): ?>
                                    <option value="<?= $loc->inventory_location_id; ?>"
                                        <?= set_select('atk_pengambilan_lokasi', $loc->inventory_location_id); ?>>
                                        <?= $loc->inventory_location_nama; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <!-- Kategori ATK -->
                    <div class="mb-4">
                        <label for="atk_product_categories" class="form-label">ATK Categories</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-tags"></i></span>
                            <select class="form-control" id="atk_product_categories" 
                                    name="atk_product_categories" onchange="getProducts()" required>
                                <option value="">-- Select Category --</option>
                                <?php foreach ($kategori as $inventory): ?>
                                    <option value="<?= $inventory->atk_categories_id; ?>">
                                        <?= $inventory->atk_categories_nama; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <!-- Produk ATK -->
                    <div class="mb-4">
                        <label for="atk_pengambilan_product" class="form-label">ATK Name</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-box"></i></span>
                            <select class="form-control" id="atk_pengambilan_product" 
                                    name="atk_pengambilan_product" onchange="getStock()" required>
                                <option value="">-- Select Product --</option>
                                <?php foreach ($produk as $p): ?>
                                    <option value="<?= $p->id ?>" data-stock="<?= $p->stok ?>">
                                        <?= $p->nama_barang ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <small id="stokTersedia" class="text-muted"></small>
                    </div>

                    <!-- Jumlah -->
                    <div class="mb-4">
                        <label for="atk_pengambilan_jumlah" class="form-label">Quantity Taken</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="fas fa-sort-numeric-up"></i></span>
                            <input type="number" class="form-control" id="atk_pengambilan_jumlah" 
                                   name="atk_pengambilan_jumlah" placeholder="Enter Quantity Taken" 
                                   min="1" required oninput="validateStock()">
                        </div>
                        <small id="stokError" class="text-danger"></small>
                    </div>

                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="fas fa-times"></i> Close
                        </button>
                        <button type="submit" class="btn btn-primary" id="submitBtn">
                            <i class="fas fa-cart-plus"></i> Save
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


<!-- Script -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
var stokTersedia = 0;

function getProducts() {
    var categoryId = $("#atk_product_categories").val();
    var lokasiId   = $("#atk_pengambilan_lokasi").val(); // 🔑 ambil lokasi dari dropdown

    $("#atk_pengambilan_product").html('<option value="">-- Select Product --</option>');
    $("#stokTersedia").text("");

    if (categoryId !== "" && lokasiId !== "") {
        $.ajax({
            url: "<?= site_url('Admin/ATK/Atk_Pengambilan_Controller/getProductsByCategory') ?>",
            type: "POST",
            data: { 
                category_id: categoryId,
                location_id: lokasiId  // 🔑 kirim juga lokasi
            },
            dataType: "json",
            success: function(response) {
                $.each(response, function(index, item) {
                    $("#atk_pengambilan_product").append(
                        '<option value="' + item.atk_product_id + '" data-stock="' + item.atk_product_stok + '">' + item.atk_product_nama + '</option>'
                    );
                });
            }
        });
    }
}


function getStock() {
    var selectedProduct = $("#atk_pengambilan_product option:selected");
    stokTersedia = parseInt(selectedProduct.data("stock")) || 0;
    if (stokTersedia > 0) {
        $("#stokTersedia").text("Available stock: " + stokTersedia);
    } else {
        $("#stokTersedia").text("No stock available");
    }
    validateStock();
}

function validateStock() {
    var jumlahDiambil = parseInt($("#atk_pengambilan_jumlah").val()) || 0;
    if (jumlahDiambil > stokTersedia) {
        $("#stokError").text("Quantity exceeds available stock!");
        $("#submitBtn").prop("disabled", true);
    } else {
        $("#stokError").text("");
        $("#submitBtn").prop("disabled", false);
    }
}
</script>
