<div class="container mt-5">
    <div class="card shadow-lg border-0 rounded-4 overflow-hidden">
        <!-- Header -->
        <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center py-3 px-4">
            <h4 class="mb-0">
                <i class="fas fa-shopping-cart me-2"></i> Keranjang Pengambilan ATK
            </h4>
            <span class="badge bg-light text-dark px-3 py-2 shadow-sm">
                <i class="fas fa-box-open me-1"></i> 
                <?= !empty($keranjang) ? count($keranjang) . ' Item' : 'Kosong' ?>
            </span>
        </div>

        <div class="card-body p-4">
            <!-- Alert Success -->
            <?php if ($this->session->flashdata('pesan_success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="fas fa-check-circle me-2"></i>
                    <?= $this->session->flashdata('pesan_success') ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <!-- Alert Error -->
            <?php if ($this->session->flashdata('pesan_error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    <?= $this->session->flashdata('pesan_error') ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <!-- Tabel -->
            <div class="table-responsive">
                <table class="table table-hover table-bordered align-middle">
                    <thead class="table-primary text-center">
                        <tr>
                            <th style="width: 5%"></th>
                            <th>Nama Barang</th>
                            <th>Kategori</th>
                            <th style="width: 10%">Jumlah</th>
                            <th style="width: 12%">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($keranjang)) : ?>
                            <?php foreach ($keranjang as $index => $item) : ?>
                                <tr>
                                    <td class="text-center"><?= $index + 1 ?></td>
                                    <td><i class="fas fa-archive text-secondary me-1"></i> <?= htmlspecialchars($item['nama_barang']) ?></td>
                                    <td><?= htmlspecialchars($item['kategori']) ?></td>
                                    <td class="text-center">
                                        <span class="badge bg-info fs-6"><?= (int)$item['jumlah'] ?></span>
                                    </td>
                                    <td class="text-center">
                                        <a href="<?= site_url('Admin/ATK/ATK_cart_controller/hapus_item/'.$index) ?>" 
                                           class="btn btn-sm btn-danger shadow-sm" 
                                           onclick="return confirm('Yakin ingin menghapus item ini?')">
                                            <i class="fas fa-trash-alt"></i> Hapus
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else : ?>
                            <tr>
                                <td colspan="5" class="text-center text-muted py-5">
                                    <i class="fas fa-shopping-basket fa-3x mb-3 text-secondary"></i>
                                    <p class="mb-0">Keranjang masih kosong</p>
                                    <small>Silakan tambahkan barang terlebih dahulu</small>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Tombol Aksi -->
            <div class="d-flex justify-content-between mt-4">
                <a href="<?= site_url('Admin/ATK/Atk_Pengambilan_controller/button') ?>" 
                   class="btn btn-outline-primary btn-lg shadow-sm">
                    <i class="fas fa-plus-circle me-1"></i> Tambah Barang
                </a>
                <?php if (!empty($keranjang)) : ?>
                    <form method="post" action="<?= site_url('Admin/ATK/Atk_Pengambilan_controller/tambah'); ?>">
                        <form method="post" action="<?= site_url('Admin/ATK/ATK_Cart_controller/checkout'); ?>">
    <form method="post" action="<?= site_url('Admin/ATK/ATK_cart_controller/checkout'); ?>">
    <button type="submit" class="btn btn-primary btn-lg shadow-sm"
            onclick="return confirm('Apakah Anda yakin ingin checkout semua barang?')">
        <i class="fas fa-save"></i> Checkout
    </button>
</form>

                    </form>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
