<!-- Edit Type Form -->
<div class="container mt-4">
    <div class="card shadow">
        <div class="card-header bg-warning text-white">
            <h5 class="m-0">Edit Data ATK</h5>
        </div>
        <div class="card-body">
            <form action="<?php echo site_url('Admin/ATK/Atk_Product_Controller/update'); ?>" method="post">
                <input type="hidden" name="atk_product_id" value="<?= $product->atk_product_id; ?>">


                <div class="mb-4">
                    <label for="client_id" class="form-label">Kategori ATK</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="fas fa-building"></i></span>
                        <select class="form-control" id="atk_product_categories" name="atk_product_categories" >
                            <option value="">-- Pilih Kategori --</option>
                            <?php foreach ($kategori as $inventory): ?>
                                <option value="<?= $inventory->atk_categories_id; ?>" <?= set_select('atk_categories', $inventory->atk_categories_id, $product->atk_product_categories == $inventory->atk_categories_id); ?>>
                                    <?= $inventory->atk_categories_nama; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>



                <div class="mb-4">
                    <label for="atk_product_nama" class="form-label">Nama ATK</label>
                    <input type="text" class="form-control" id="atk_product_nama" name="atk_product_nama" 
                           value="<?= set_value('atk_product_nama', $product->atk_product_nama); ?>" 
                           placeholder="Masukkan nama ATK" >
                </div>

                
                <div class="mb-4">
                    <label for="client_id" class="form-label">Brand ATK</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="fas fa-building"></i></span>
                        <select class="form-control" id="atk_product_brand" name="atk_product_brand" >
                            <option value="">-- Pilih Brand --</option>
                            <?php foreach ($brand as $inventory): ?>
                                <option value="<?= $inventory->brand_categories_id; ?>" <?= set_select('brand_categories', $inventory->brand_categories_id, $product->atk_product_brand == $inventory->brand_categories_id); ?>>
                                    <?= $inventory->brand_categories_nama; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>

                <div class="mb-4">
                    <label for="atk_product_stok" class="form-label">Stok</label>
                    <input type="text" class="form-control" id="atk_product_stok" name="atk_product_stok" 
                           value="<?= set_value('atk_product_stok', $product->atk_product_stok); ?>" 
                           placeholder="Masukkan stok ATK" >
                </div>


                <div class="mb-4">
                    <label for="atk_product_uom" class="form-label">Satuan</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="fas fa-ruler"></i></span>
                        <select class="form-control" id="atk_product_uom" name="atk_product_uom">
                            <option value="" disabled selected>-- Pilih Satuan --</option>
                            <?php foreach ($uom as $loc): ?>
                                <option value="<?= $loc->uom_categories_id; ?>" <?= set_select('uom_categories', $loc->uom_categories_id, $product->atk_product_uom == $loc->uom_categories_id); ?>>
                                    <?= $loc->uom_categories_nama; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>



                
                <div class="mb-4">
                    <label for="atk_product_location" class="form-label">Lokasi Inventory</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="fas fa-map-marker-alt"></i></span>
                        <select class="form-control" id="atk_product_location" name="atk_product_location">
                            <option value="" disabled selected>-- Pilih Lokasi --</option>
                            <?php foreach ($locations as $loc): ?>
                                <option value="<?= $loc->inventory_location_id; ?>" <?= set_select('inventory_location', $loc->inventory_location_id, $product->atk_product_location == $loc->inventory_location_id); ?>>
                                    <?= $loc->inventory_location_nama; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>

    <div class="mb-4">
    <label for="update_date" class="form-label">Update Date</label>
    <input type="datetime-local" class="form-control" id="update_date" name="update_date" 
           value="<?= date('Y-m-d\TH:i', strtotime($product->update_date)); ?>">
</div>


                <div class="mb-4">
                    <label for="atk_product_notes" class="form-label">Notes</label>
                    <input type="text" class="form-control" id="atk_product_notes" name="atk_product_notes" 
                           value="<?= set_value('atk_product_notes', $product->atk_product_notes); ?>" 
                           placeholder="Masukkan Notes" >
                </div>

            


                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-warning me-2">Update</button>
                    <a href="<?php echo site_url('Admin/ATK/Atk_Product_Controller/index'); ?>" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>
