<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin_Laporan_Controller extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->database();
        $this->load->library(['session']); 
        $this->load->helper(['url','form']);

        // cek login
        if (!$this->session->userdata('logged_in')) {
            redirect('auth/auth_controller/login');
        }
    }

    public function index() {
        $filter = $this->input->get('filter'); // ambil filter dari query string
        $this->db->from('tamu');

        // filter per minggu
        if ($filter == 'minggu') {
            $this->db->where('YEARWEEK(waktu_masuk, 1) = YEARWEEK(CURDATE(), 1)');
        }

        // filter per bulan
        if ($filter == 'bulan') {
            $this->db->where('MONTH(waktu_masuk)', date('m'));
            $this->db->where('YEAR(waktu_masuk)', date('Y'));
        }

        $this->db->order_by('waktu_masuk', 'DESC');
        $data['tamu'] = $this->db->get()->result();

        $this->load->view('Admin/laporan_admin', $data);
    }
}
