<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Barang_masuk_model extends CI_Model {

    private $table = 'barang_masuk'; // nama tabel

    public function __construct() {
        parent::__construct();
    }
 
    // Ambil semua data 
    public function get_all() {
        return $this->db->order_by('created_at', 'DESC')
                        ->get($this->table)
                        ->result();
    }

    // Ambil data by id
    public function get_by_id($id) {
        return $this->db->where('id', $id)
                        ->get($this->table)
                        ->row();
    } 

    // Insert data
    public function insert($data) {
        return $this->db->insert($this->table, $data);
    }

    // Update data
    public function update($id, $data) { 
        return $this->db->where('id', $id)
                        ->update($this->table, $data);
    }

    // Delete data
    public function delete($id) {
        return $this->db->where('id', $id)
                        ->delete($this->table);
    }
    public function count_barang_keluar() {
    return $this->db->count_all('barang_masuk'); // ganti kalau nama tabel beda
}
public function count_all() {
    return $this->db->count_all('barang_masuk'); // ganti nama tabel sesuai database
}

 public function get_data_with_filters($search = null, $tanggal = null) {
        $this->db->from($this->table);

        // 1. Filter Pencarian (Search: nama_pengirim / nama_vendor)
        if (!empty($search)) {
            $this->db->group_start();
            $this->db->like('nama_pengirim', $search);
            $this->db->or_like('nama_vendor', $search);
            $this->db->group_end(); 
        }

        // 2. Filter Tanggal (tanggal)
        if (!empty($tanggal)) {
            $this->db->where('tanggal', $tanggal);
        }

        // Urutkan data
        $this->db->order_by('created_at', 'DESC');
        
        return $this->db->get()->result();
    }

public function get_filtered($start_date, $end_date) {
    return $this->db->where('tanggal >=', $start_date)
                    ->where('tanggal <=', $end_date)
                    ->order_by('tanggal', 'DESC')
                    ->get($this->table)
                    ->result();
}


 

}
