<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Tamu_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    // Ambil semua dengan optional filter array (tanggal_awal, tanggal_akhir, keyword)
    public function get_all($filter = [])
{
    $this->db->select('*');
    $this->db->from('tamu');

    // Filter tanggal - MENGGUNAKAN created_at
    if (!empty($filter['tanggal_awal']) && !empty($filter['tanggal_akhir'])) {
        $this->db->where('DATE(created_at) >=', $filter['tanggal_awal']);
        $this->db->where('DATE(created_at) <=', $filter['tanggal_akhir']);
    } 

    // Filter keyword
    if (!empty($filter['keyword'])) {
        $this->db->group_start();
        $this->db->like('nama', $filter['keyword']);
        $this->db->or_like('instansi', $filter['keyword']);
        $this->db->or_like('keperluan', $filter['keyword']);
        $this->db->or_like('no_visitor', $filter['keyword']);
        $this->db->or_like('no_tamu', $filter['keyword']);
        $this->db->group_end();
    }

    // Filter Lokasi <--- PERBAIKAN: Logika Filter Lokasi di Model
    if (!empty($filter['location'])) {
        $this->db->where('location', $filter['location']);
    }
    // End Filter Lokasi di Model

    $this->db->order_by('created_at', 'DESC');
    return $this->db->get()->result();
}

    // Compatibility: ambil semua tanpa filter
    public function getAllTamu() {
        return $this->db->get('tamu')->result(); 
    }

    // Insert
    public function insert($data) {
        return $this->db->insert('tamu', $data);
    }

    public function insert_tamu($data){
        return $this->db->insert('tamu', $data);
    }
    // Basic get by id
    public function get_by_id($id) {
        return $this->db->get_where('tamu', ['id' => $id])->row();
    }

    public function getTamuById($id) {
        return $this->db->get_where('tamu', ['id' => $id])->row();
    }

    // Update (generic)
    public function update($id, $data) {
        $this->db->where('id', $id);
        return $this->db->update('tamu', $data);
    }

    public function updateTamu($id, $data) {
        return $this->db->where('id', $id)->update('tamu', $data);
    }

    // Delete
    public function delete($id) {
        return $this->db->delete('tamu', ['id' => $id]);
    }

    public function deleteTamu($id) {
        return $this->db->delete('tamu', ['id' => $id]);
    } 

    // ✅ PERBAIKAN: Menggunakan kolom 'created_at' untuk penghitungan hari ini
    public function count_today()
    {
        // Pastikan Timezone sudah diatur di index.php/config/controller agar tanggalnya tepat
        $today = date('Y-m-d');
        // Filter berdasarkan tanggal di kolom created_at
        $this->db->where('DATE(created_at)', $today); 
        return $this->db->count_all_results('tamu');
    }

    // Generate nomor tamu
    public function generate_no_tamu() {
        $this->db->select('RIGHT(no_tamu,3) as kode', false);
        $this->db->order_by('no_tamu','DESC');
        $this->db->limit(1);
        $query = $this->db->get('tamu');
        if($query->num_rows() <> 0){
            $data = $query->row();
            $kode = intval($data->kode) + 1;
        } else {
            $kode = 1;
        }
        $kodemax = str_pad($kode, 3, "0", STR_PAD_LEFT);
        return "TAMU-".$kodemax;
    }

    // Variations for list retrieval (compat)
    public function get_all_latest() {
        $this->db->order_by('created_at', 'DESC');
        return $this->db->get('tamu')->result();
    }

    public function get_paged($limit, $offset) {
        return $this->db->order_by('id', 'DESC')
                        ->get('tamu', $limit, $offset)
                        ->result();
    }

    public function count_all() {
        return $this->db->count_all('tamu');
    } 

    // Older filter signature (dipertahankan)
    public function get_filtered($start = null, $end = null, $search = null)
    {
        $this->db->from('tamu');
        if ($start && $end) {
            $this->db->where('DATE(created_at) >=', $start); // Ganti dari waktu_masuk ke created_at
            $this->db->where('DATE(created_at) <=', $end);   // Ganti dari waktu_masuk ke created_at
        }
        if ($search) {
            $this->db->group_start();
            $this->db->like('nama', $search);
            $this->db->or_like('instansi', $search);
            $this->db->or_like('keperluan', $search);
            $this->db->group_end();
        }
        return $this->db->get()->result();
    }
}