<!DOCTYPE html>
<html>
<head>
    <title>Edit Profil Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">
    <style>
        /* CSS Tambahan untuk mempercantik */
        .profile-avatar-container {
            display: flex;
            justify-content: center;
            align-items: center;
            flex-direction: column;
            margin-bottom: 20px;
        }
        .profile-avatar {
            width: 150px; /* Ukuran yang sedikit lebih besar */
            height: 150px;
            object-fit: cover;
            border-radius: 50%; /* Membuatnya benar-benar bulat */
            border: 4px solid #0dcaf0; /* Border dengan warna info/primary */
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        /* Mengubah warna header agar lebih profesional */
        .card-header-custom {
            background-color: #0dcaf0; /* Warna biru muda/Cyan (Info) */
            color: white;
            border-bottom: none;
        }
    </style>
</head>
<body class="bg-light">

<div class="container mt-5 mb-5">
    <div class="row justify-content-center">
        <div class="col-lg-8 col-md-10">
            <div class="card shadow-lg border-0 rounded-4">
                
                <div class="card-header card-header-custom text-center rounded-top-4 p-3">
                    <h3 class="mb-0">✏️ Pengaturan Akun Admin</h3>
                    <p class="mb-0 text-white-50">Perbarui informasi profil dan keamanan Anda.</p>
                </div>
                
                <div class="card-body p-5">
                    <form action="<?= base_url('index.php/User_controller/update_profil/'.$admin->id) ?>" method="post" enctype="multipart/form-data">
                        
                        <div class="profile-avatar-container">
                            <?php 
                                $foto_url = !empty($admin->foto) ? base_url('asset/img/admin/'.$admin->foto) : base_url('asset/img/admin/default.png');
                            ?>
                            <img src="<?= $foto_url ?>" alt="Foto Profil" class="profile-avatar mb-3">
                            
                            <div class="input-group mb-3 w-75">
                                <label class="input-group-text">🖼 Ganti Foto</label>
                                <input type="file" name="foto" class="form-control" accept="image/*">
                            </div>
                            <small class="text-muted mb-4">Maksimum 2MB. Kosongkan jika tidak ingin mengubah foto.</small>
                        </div>
                        
                        <h5 class="mb-3 text-secondary border-bottom pb-2">Informasi Dasar</h5>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">📝 Nama Lengkap</label>
                                <input type="text" name="nama_lengkap" class="form-control shadow-sm" value="<?= $admin->nama_lengkap ?>" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">💼 Jabatan/Pekerjaan</label>
                                <input type="text" name="job" class="form-control shadow-sm" value="<?= $admin->job ?>" required>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">👤 Username</label>
                                <input type="text" name="username" class="form-control shadow-sm" value="<?= $admin->username ?>" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">📧 Email</label>
                                <input type="email" name="email" class="form-control shadow-sm" value="<?= $admin->email ?>" required>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-4">
                                <label class="form-label fw-bold">🎂 Tanggal Lahir</label>
                                <input type="date" name="dob" class="form-control shadow-sm" value="<?= $admin->dob ?>" required>
                            </div>
                            <div class="col-md-6 mb-4">
                                <label class="form-label fw-bold">⚙️ Role Akun</label>
                                <select name="role" class="form-control shadow-sm" required>
                                    <option value="admin" <?= ($admin->role == 'admin') ? 'selected' : '' ?>>Admin</option>
                                    <option value="user" <?= ($admin->role == 'user') ? 'selected' : '' ?>>User</option>
                                </select>
                            </div>
                        </div>

                        <h5 class="mb-3 text-secondary border-bottom pb-2">Keamanan</h5>
                        
                        <div class="mb-4">
                            <label class="form-label fw-bold">🔑 Password Baru</label>
                            <input type="password" name="password" class="form-control shadow-sm" placeholder="Masukkan password baru...">
                            <small class="text-info mt-1">Kosongkan kolom ini jika Anda tidak ingin mengubah password.</small>
                        </div>

                        <div class="d-flex justify-content-between pt-3 border-top">
                             <a href="<?= base_url('index.php/User_controller') ?>" 
                           class="btn btn-outline-secondary px-4">
                            ⬅ Kembali
                        </a>
                            <button type="submit" class="btn btn-success px-4 shadow-sm">
                                💾 Simpan Perubahan
                            </button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>