<!DOCTYPE html>
<html>
<head>
    <title>Profil Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">
    <style>
        body {
            background-color: #f8f9fa; /* Latar belakang lebih terang */
        }
        .card {
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.08); /* Shadow lebih halus */
            border: none;
        }
        .profile-header {
            background-color: #0d6efd; /* Biru Primer Bootstrap */
            color: white;
            padding: 30px 20px;
            border-top-left-radius: 15px;
            border-top-right-radius: 15px;
        }
        
        /* Container untuk foto agar z-index dan posisi tetap terjaga */
        .avatar-container {
            margin-top: -75px; /* Menaikkan avatar agar menumpang di header */
            position: relative; /* Penting untuk penempatan */
            display: inline-block;
        }
        
        .profile-avatar {
            width: 150px;
            height: 150px;
            object-fit: cover;
            border-radius: 50%; /* Membuat foto bulat */
            border: 5px solid white; /* Border putih */
            box-shadow: 0 0 0 3px #20c997; /* Border hijau muda di luar putih */
            cursor: pointer; /* Menunjukkan bahwa gambar dapat diklik */
            transition: 0.3s;
        }
        .profile-avatar:hover {
            transform: scale(1.05);
            box-shadow: 0 0 0 3px #0d6efd; /* Perubahan border saat hover */
        }
        .detail-item {
            padding: 12px 0;
            border-bottom: 1px solid #eee;
        }
        .detail-item strong {
            color: #495057; /* Warna teks gelap */
            font-weight: 500;
        }
        .detail-item span {
            color: #212529;
            font-weight: 600;
        }
        
        /* Styling untuk Modal Pratinjau */
        #photoPreviewModal .modal-content {
            background: transparent;
            border: none;
        }
        #photoPreviewModal .modal-body {
            padding: 0;
            text-align: center;
        }
        #photoPreviewModal img {
            max-width: 100%;
            height: auto;
            border-radius: 10px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.3);
        }
        #photoPreviewModal .btn-close {
            filter: invert(100%); /* Membuat tombol close putih agar terlihat di backdrop */
            opacity: 0.8;
        }
    </style>
</head>
<body>

<div class="container mt-5 mb-5">
    <div class="row justify-content-center">
        <div class="col-lg-9 col-md-10">
            <div class="card">
                
                <div class="profile-header text-center">
                    <h2 class="mb-0"><i class="bi bi-person-circle me-2"></i> Detail Akun</h2>
                    <p class="text-white-50 mb-0">Informasi Lengkap Profil Admin</p>
                </div>

                <div class="card-body pt-0">
                    <div class="row">
                        
                        <div class="col-md-4 text-center">
                            
                            <?php
                            $foto = !empty($admin->foto) ? $admin->foto : 'default.png';
                            $foto_url = base_url('asset/img/admin/'.$foto); // Simpan URL foto
                            ?>
                            
                            <div class="avatar-container">
                                <a href="#" data-bs-toggle="modal" data-bs-target="#photoPreviewModal">
                                    <img src="<?= $foto_url ?>" 
                                         alt="Foto Profil" 
                                         class="profile-avatar">
                                </a>
                            </div>
                            
                            <h4 class="mt-3 mb-1"><?= $admin->nama_lengkap ?></h4>
                            <p class="text-muted mb-4"><?= $admin->job ?></p>
                            
                            <div class="d-grid gap-2 mb-4">
                                <a href="<?= base_url('index.php/User_controller') ?>" 
                                   class="btn btn-outline-secondary">
                                    <i class="bi bi-arrow-left me-1"></i> Kembali ke Master User
                                </a>
                            </div>
                        </div>

                        <div class="col-md-8 pt-4 pt-md-5 ps-md-5">
                            <h5 class="text-primary mb-4 pb-2 border-bottom">Data Pribadi & Akun</h5>
                            
                            <div class="list-group list-group-flush">
                                <div class="detail-item d-flex justify-content-between">
                                    <strong><i class="bi bi-person me-2"></i> Username:</strong> 
                                    <span><?= $admin->username ?></span>
                                </div>
                                <div class="detail-item d-flex justify-content-between">
                                    <strong><i class="bi bi-envelope me-2"></i> Email:</strong> 
                                    <span><?= $admin->email ?></span>
                                </div>
                                <div class="detail-item d-flex justify-content-between">
                                    <strong><i class="bi bi-gift me-2"></i> Tanggal Lahir:</strong> 
                                    <span><?= $admin->dob ?></span>
                                </div>
                                <div class="detail-item d-flex justify-content-between">
                                    <strong><i class="bi bi-shield-lock me-2"></i> Role Akun:</strong> 
                                    <span><?= ucfirst($admin->role) ?></span>
                                </div>
                                <div class="detail-item d-flex justify-content-between">
                                    <strong><i class="bi bi-calendar-check me-2"></i> Tanggal Dibuat:</strong> 
                                    <span><?= date('d M Y, H:i', strtotime($admin->created_at)) ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="photoPreviewModal" tabindex="-1" aria-labelledby="photoPreviewModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header border-0 bg-transparent p-2">
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <img src="<?= $foto_url ?>" alt="Foto Profil Diperbesar">
      </div>
    </div>
  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>