<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Login Admin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1"> <!-- WAJIB UNTUK RESPONSIVE -->

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">

    <style>
        :root {
            --primary-color: #007bff;
        }

        body {
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            background: url("<?= base_url('asset/img/log.jpg') ?>") no-repeat center center;
            background-size: cover;
            font-family: 'Poppins', sans-serif;
            padding: 15px; /* penting agar tidak mepet pinggir HP */
        }

        /* CARD RESPONSIVE */
        .login-card {
            width: 100%;
            max-width: 420px; /* batas aman di hp & desktop */
            background: #fff;
            padding: 30px;
            border-radius: 20px;
            box-shadow: 0px 8px 20px rgba(0,0,0,0.2);
            animation: fadeInUp 0.7s ease;
        }

        /* LOGO RESPONSIVE */
        .logo {
            width: 130px;
            max-width: 50%;
            margin-bottom: 10px;
        }

        .form-control {
            border-radius: 10px;
            padding: 12px;
        }

        .btn-primary {
            padding: 12px;
            border-radius: 10px;
            font-weight: bold;
        }

        /* Animasi */
        @keyframes fadeInUp {
            from {opacity: 0; transform: translateY(20px);}
            to {opacity: 1; transform: translateY(0);}
        }

        /* AGAR DI HP SANGAT KECIL TETAP BAGUS */
        @media (max-width: 380px) {
            .login-card {
                padding: 20px;
            }
            .logo {
                width: 110px;
            }
        }
    </style>
</head>

<body>

    <!-- CARD -->
    <div class="card login-card">
        <div class="text-center mb-3">
            <img src="<?= base_url('asset/img/asiaserv-logo.png') ?>" class="logo" alt="Logo">
            <h4 class="mt-2">Login Admin</h4>
            <p class="text-muted small">Silakan masuk untuk melanjutkan</p>
        </div>

        <form method="post" action="<?= site_url('auth/login_action') ?>">

            <div class="mb-3">
                <label class="form-label">Username</label>
                <div class="input-group">
                    <span class="input-group-text bg-light"><i class="fas fa-user"></i></span>
                    <input type="text" name="username" class="form-control" placeholder="Masukkan username" required>
                </div>
            </div>

            <div class="mb-4">
                <label class="form-label">Password</label>
                <div class="input-group input-group-password">
                    <span class="input-group-text bg-light"><i class="fas fa-lock"></i></span>
                    <input type="password" name="password" id="passwordInput" class="form-control" placeholder="Masukkan password" required>
                    <span class="input-group-text" id="togglePassword"><i class="fas fa-eye-slash"></i></span>
                </div>
            </div>

            <button type="submit" class="btn btn-primary w-100">Login</button>
        </form>
    </div>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        const togglePassword = document.querySelector('#togglePassword');
        const passwordInput = document.querySelector('#passwordInput');
        const eyeIcon = togglePassword.querySelector('i');

        togglePassword.addEventListener('click', () => {
            const type = passwordInput.type === 'password' ? 'text' : 'password';
            passwordInput.type = type;
            eyeIcon.classList.toggle('fa-eye');
            eyeIcon.classList.toggle('fa-eye-slash');
        });
    });
</script>

<?php if($this->session->flashdata('error')): ?>
<script>
Swal.fire({
    icon: 'error',
    title: 'Login Gagal',
    text: "<?= $this->session->flashdata('error'); ?>",
    confirmButtonColor: '#d33'
});
</script>
<?php endif; ?>

</body>
</html>
