<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Laporan Barang Keluar</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 11px;
            margin: 30px;
            color: #212529;
        }
        .logo-left {
            position: absolute;
            top: 20px;
            left: 30px;
            height: 60px;
        }
        h2, p {
            text-align: center;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
            font-size: 10.5px;
        }
        thead tr {
            background-color: #dc3545;
            color: #fff;
        }
        th, td {
            border: 1px solid #000;
            padding: 6px 4px;
            text-align: center;
            vertical-align: middle;
        }
        tbody tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        .foto-img {
            width: 55px;
            height: 55px;
            object-fit: cover;
        }
    </style>
</head>
<body>

<?php 
    date_default_timezone_set('Asia/Jakarta');
    $username = $this->session->userdata('nama_lengkap') ?? 
                $this->session->userdata('username') ?? 
                'Tidak diketahui';
    $tanggalCetak = date('d-m-Y H:i');

    // ==========================
    // LOGO BASE64 (pasti tampil)
    // ==========================
    $logoPath = FCPATH . "asset/img/asiaserv-logo.png";
    $logoBase64 = "";

    if (file_exists($logoPath)) {
        $logoBase64 = "data:image/png;base64," . base64_encode(file_get_contents($logoPath));
    }
?>

<?php if ($logoBase64): ?>
    <img src="<?= $logoBase64 ?>" class="logo-left" alt="Logo">
<?php endif; ?>

<h2 style="color:#dc3545;margin-bottom:5px;">
    LAPORAN DATA BARANG KELUAR
</h2>
<p>Dicetak oleh: <?= htmlspecialchars($username) ?></p>
<p>Tanggal Cetak: <?= $tanggalCetak ?></p>

<table>
    <thead>
        <tr>
            <th>No</th>
            <th>PIC</th>
            <th>Jenis Barang</th>
            <th>Jumlah</th>
            <th>Driver</th>
            <th>Origin</th>
            <th>Tujuan</th>
            <th>Tanggal</th>
            <th>Waktu Keluar</th>
            <th>Foto</th>
        </tr>
    </thead>

    <tbody>

        <?php if (!empty($barang_keluar)): ?>
            <?php $no = 1; foreach ($barang_keluar as $b): ?>
                <?php 
                    $foto_name = $b->foto ?? "";
                    $foto_path = FCPATH . "uploads/" . $foto_name; 
                    $foto_url  = base_url("uploads/" . $foto_name); 
                ?>

                <tr>
                    <td><?= $no++ ?></td>
                    <td><?= htmlspecialchars($b->pic) ?></td>
                    <td><?= htmlspecialchars($b->jenis_barang) ?></td>
                    <td><?= htmlspecialchars($b->jumlah) ?></td>
                    <td><?= htmlspecialchars($b->driver) ?></td>
                    <td><?= htmlspecialchars($b->origin) ?></td>
                    <td><?= htmlspecialchars($b->tujuan) ?></td>
                    <td><?= date('d-m-Y', strtotime($b->tanggal)) ?></td>
                    <td><?= date('H:i', strtotime($b->waktu_keluar)) ?></td>

                    <td>
                        <?php if (!empty($foto_name) && file_exists($foto_path)): ?>
                            <img src="<?= $foto_url ?>" class="foto-img">
                        <?php else: ?>
                            <em>Tidak Ada</em>
                        <?php endif; ?>
                    </td>
                </tr>

            <?php endforeach; ?>
        <?php else: ?>
            <tr>
                <td colspan="10" style="text-align:center;font-style:italic;color:#777;">
                    Tidak ada data barang keluar
                </td>
            </tr>
        <?php endif; ?>

    </tbody>
</table>

<p style="text-align:right;font-size:10px;color:#555;margin-top:20px;">
    <em>Laporan ini dibuat otomatis oleh sistem Asiaserv.</em>
</p>

</body>
</html>
