<!DOCTYPE html>
<html lang="id">
<head>
    <title>Edit Data Barang Keluar</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">
    <style>
        :root {
            --color-danger: #dc3545; /* Merah untuk Keluar */
            --color-secondary: #6c757d;
            --bg-main: #f4f7f9;
        }
        body {
            background-color: var(--bg-main);
            font-family: 'Poppins', sans-serif;
            padding-top: 50px;
            padding-bottom: 50px;
        }
        .card-custom {
            max-width: 800px;
            margin: auto;
            border-radius: 18px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.15);
            border: none;
        }
        .card-header-custom {
            /* Warna Merah/Orange untuk kesan 'Keluar/Out' */
            background: linear-gradient(135deg, #dc3545, #fd7e14); 
            color: white;
            font-weight: 700;
            font-size: 1.5rem;
            border-top-left-radius: 18px;
            border-top-right-radius: 18px;
            padding: 25px 30px;
        }
        .form-label {
            font-weight: 600;
            color: #495057;
        }
        .form-control {
            border-radius: 10px;
            transition: all 0.2s;
        }
        .form-control:focus {
            border-color: var(--color-danger);
            box-shadow: 0 0 0 0.25rem rgba(220, 53, 69, 0.25);
        }
        .form-section-title {
            font-size: 1.1rem;
            color: var(--color-danger);
            font-weight: 700;
            margin-top: 25px;
            margin-bottom: 15px;
            padding-bottom: 5px;
            border-bottom: 2px solid #f8d7da;
        }
        .img-preview {
            max-width: 120px;
            height: auto;
            border-radius: 8px;
            border: 2px solid var(--color-danger);
            padding: 3px;
            margin-top: 10px;
        }
        .btn-action {
            border-radius: 12px;
            min-width: 150px;
            font-weight: 600;
            padding: 10px 20px;
        }
    </style>
</head>
<body>

<div class="container">
    <div class="card card-custom">
        <div class="card-header-custom">
            <i class="bi bi-pencil-square me-2"></i> Edit Data Barang Keluar
        </div>

        <div class="card-body p-4 p-md-5">
            <?= validation_errors('<div class="alert alert-danger"><i class="bi bi-exclamation-triangle-fill me-2"></i>','</div>'); ?>

            <form id="editForm" action="<?= site_url('barang_keluar_controller/update/'.$barang->id) ?>" method="post" enctype="multipart/form-data">
                
                <div class="form-section-title"><i class="bi bi-box me-2"></i> Detail Barang</div>
<div class="row g-4">
    <div class="col-md-6">
        <label class="form-label">Jenis Barang</label>
        <input type="text" name="jenis_barang" value="<?= htmlspecialchars($barang->jenis_barang) ?>" class="form-control" required>
    </div>
    <div class="col-md-6">
        <label class="form-label">Jumlah</label>
        <input type="number" name="jumlah" value="<?= htmlspecialchars($barang->jumlah) ?>" class="form-control" required>
    </div>

    <!-- Tambahan: Origin -->
    <div class="col-md-6">
        <label class="form-label">Origin (Asal Pengiriman)</label>
        <select name="origin" class="form-control" required>
            <option value="">-- Pilih Origin --</option>
            <option value="Arkadia Head Office" <?= ($barang->origin == 'Arkadia Head Office') ? 'selected' : '' ?>>Arkadia Head Office</option>
            <option value="Workshop BSD" <?= ($barang->origin == 'Workshop BSD') ? 'selected' : '' ?>>Workshop BSD</option>
        </select>
    </div>

    <div class="col-md-6">
        <label class="form-label">Tujuan Pengiriman</label>
        <input type="text" name="tujuan" value="<?= htmlspecialchars($barang->tujuan) ?>" class="form-control" required>
    </div>
</div>


                <div class="form-section-title"><i class="bi bi-people me-2"></i> Penanggung Jawab & Waktu</div>
                <div class="row g-4">
                    <div class="col-md-6">
                        <label class="form-label">PIC (Person In Charge)</label>
                        <input type="text" name="pic" value="<?= htmlspecialchars($barang->pic) ?>" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Driver / Kurir</label>
                        <input type="text" name="driver" value="<?= htmlspecialchars($barang->driver) ?>" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Tanggal Keluar</label>
                        <input type="date" name="tanggal" value="<?= htmlspecialchars($barang->tanggal) ?>" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Waktu Keluar</label>
                        <input type="time" name="waktu_keluar" value="<?= htmlspecialchars($barang->waktu_keluar) ?>" class="form-control" required>
                    </div>
                </div>

                <div class="form-section-title"><i class="bi bi-camera me-2"></i> Dokumentasi Foto</div>
                <div class="mb-3">
                    <label class="form-label">Ganti Foto (Opsional)</label>
                    <input type="file" name="foto" class="form-control" accept="image/*">
                    <small class="text-muted">Pilih file baru jika ingin mengganti foto saat ini.</small>

                    <?php if(!empty($barang->foto)): ?>
                        <div class="mt-3">
                            <p class="mb-1 fw-bold text-danger">Foto Saat Ini:</p>
                            <img src="<?= base_url('uploads/'.$barang->foto) ?>" alt="Foto Barang Saat Ini" class="img-preview shadow-sm">
                        </div>
                    <?php endif; ?>
                </div>

                <div class="d-flex justify-content-end gap-3 mt-4 pt-4 border-top">
                    <a href="<?= site_url('barang_keluar_controller') ?>" class="btn btn-secondary btn-action">
                        <i class="bi bi-arrow-left me-1"></i> Kembali
                    </a>
                    <button type="button" id="btnUpdate" class="btn btn-danger btn-action">
                        <i class="bi bi-save me-1"></i> Update Data
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
document.getElementById("btnUpdate").addEventListener("click", function(){
    // Tambahkan validasi sederhana sebelum SweetAlert
    const form = document.getElementById('editForm');
    if (!form.checkValidity()) {
        form.reportValidity(); // Tampilkan pesan error default browser
        return;
    }

    Swal.fire({
        title: 'Konfirmasi Perubahan Data?',
        text: "Anda yakin ingin menyimpan perubahan pada data barang keluar ini?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#dc3545', /* Warna Merah */
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Ya, Update!',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: 'Menyimpan...',
                text: 'Mohon tunggu sebentar',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading()
                }
            });
            form.submit();
        }
    });
});
</script>

<?php if(isset($this->session) && $this->session->flashdata('success')): ?>
<script>
    Swal.fire({
        icon: 'success',
        title: 'Berhasil!',
        text: '<?= $this->session->flashdata('success'); ?>',
        showConfirmButton: false,
        timer: 1800,
        position: 'center'
    });
</script>
<?php endif; ?> 

</body>
</html>