<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inbound Goods Data</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">
    
    <style>
        :root {
            --primary-color: #0d6efd; /* Blue */
            --dark-header: #212529; /* Near Black */
            --bg-main: #f8f9fa; /* Lighter background color */
            --card-shadow: 0 10px 30px rgba(0,0,0,0.08);
        }
        body { 
            background-color: var(--bg-main); 
            font-family: 'Poppins', sans-serif; 
            color: #343a40; 
            padding-top: 20px;
        }
        .main-card { 
            background-color: #fff; 
            border-radius: 15px; 
            box-shadow: var(--card-shadow); 
            margin-top: 20px; 
            border: none;
            overflow: hidden;
        }
        .card-header-custom { 
            background-color: var(--dark-header); /* Stronger header color */
            color: #fff; 
            padding: 20px 30px; 
            border-radius: 15px 15px 0 0;
            display: flex; 
            justify-content: space-between; 
            align-items: center; 
        }
        .filters-toolbar { 
            padding: 20px 30px 15px; 
            display: flex; 
            justify-content: space-between; 
            align-items: center; 
            flex-wrap: wrap; 
            gap: 15px; 
            border-bottom: 1px solid #e9ecef;
        }
        .filters-group .form-control, .filters-group .btn { 
            border-radius: 8px; 
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }
        .table thead th { 
            background-color: var(--primary-color) !important; /* Changed to primary color */
            color: white; 
            text-align: center; 
            vertical-align: middle; 
            font-weight: 600; 
        }
        .table tbody td { 
            text-align: center; 
            vertical-align: middle; 
            font-size: 0.9rem;
        }
        .table-striped tbody tr:nth-of-type(odd) {
            background-color: #f7f7f7;
        }
        
        /* === PHOTO PREVIEW ENHANCEMENTS === */
        .foto-barang { 
            width: 70px; 
            height: 70px; 
            object-fit: cover; 
            border-radius: 50%; /* Made circular */
            cursor: pointer; 
            transition: transform .3s, box-shadow .3s, border .3s; 
            border: 3px solid transparent; 
        }
        .foto-barang:hover { 
            transform: scale(1.1); /* Zoom effect */
            box-shadow: 0 4px 10px rgba(0,0,0,0.2); 
            border: 3px solid #ffc107; /* Yellow border on hover */
        }
        
        /* === ENHANCED PHOTO MODAL === */
        #previewFoto {
            max-width: 100%;
            height: auto;
            max-height: 80vh; /* Limit max height */
            border-radius: 10px;
            border: 5px solid #fff;
            box-shadow: 0 10px 20px rgba(0,0,0,0.3);
            transition: all 0.3s ease-in-out;
        }
        .modal-body {
            background: #f8f9fa; /* Modal body background */
        }
        
        .btn-sm-action { 
            border-radius: 6px; 
            padding: 6px 10px;
            font-size: 0.85rem;
        }
        #pagination button { 
            margin: 0 2px; 
            min-width: 38px; 
        }
        /* PERBESAR FONT UNTUK HALAMAN OUTBOUND GOODS LIST */
#barangTable th,
#barangTable td {
    font-size: 20px !important;   /* kamu bisa ganti jadi 16 kalau mau lebih besar */
}

#barangTable td span.badge {
    font-size: 14px !important;
    padding: 6px 10px !important;
}

.card-header-custom h2 {
    font-size: 26px !important; /* judul card header besar */
}

.toolbar-container input.form-control,
.toolbar-container button,
.toolbar-container a.btn {
    font-size: 14px !important;
}

.btn-action {
    font-size: 13px !important;
    padding: 7px 12px !important;
}

    </style>
</head>
<body class="p-4">

<div class="container-fluid"> <div class="main-card">
        <div class="card-header-custom">
            <h3><i class="fa fa-boxes me-2"></i>Inbound Goods Data</h3>
            <a href="<?= site_url('barang_masuk_controller/form') ?>" class="btn btn-warning shadow-sm fw-bold"> <i class="fa fa-plus me-1"></i> Add New Item
            </a>
        </div> 
        
        <div class="filters-toolbar">
            <div class="d-flex flex-wrap gap-2 filters-group">
                <input type="text" id="searchInput" class="form-control" placeholder="Search sender/vendor/registration" style="width: 250px;">
                <input type="date" id="filterTanggal" class="form-control" title="Filter by Date" style="width: 150px;">
                <button id="clearFilter" class="btn btn-outline-danger"><i class="fa fa-sync-alt"></i> Reset</button>
            </div>
            <div class="d-flex gap-2 filters-group">
                <a href="#" id="exportExcel" class="btn btn-success shadow-sm">
                    <i class="fa fa-file-excel me-1"></i> Export Excel
                </a>
                <a href="#" id="exportPDF" class="btn btn-danger shadow-sm">
                    <i class="fa fa-file-pdf me-1"></i> Export PDF
                </a>
            </div>
        </div>
        
        <div class="card-body p-0 table-responsive">
            <table class="table table-bordered table-striped table-hover mb-0" id="barangTable">
                <thead class="table-dark">
                    <tr>
                        <th style="width: 5%;">No</th>
                        <th>Sender</th>
                        <th>Vendor</th>
                        <th>Reg. No</th> 
                        <th>Type</th>
                        <th>Recipient</th> 
                        <th>Security</th>
                        <th>Location</th>
                        <th style="width: 10%;">Date</th>
                        <th style="width: 8%;">Time</th>
                        <th style="width: 10%;">Photo</th>
                        <th style="width: 10%;">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $no = 1; foreach($barang_masuk as $b): ?>
                    <tr data-tanggal="<?= $b->tanggal ?>" data-pengirim="<?= strtolower($b->nama_pengirim) ?>" data-vendor="<?= strtolower($b->nama_vendor) ?>" data-reg="<?= strtolower($b->no_registrasi) ?>">
                        <td><?= $no++ ?></td>
                        <td class="text-start fw-medium"><?= $b->nama_pengirim ?></td>
                        <td class="text-start"><?= $b->nama_vendor ?></td>
                        <td><?= $b->no_registrasi ?></td>
                        <td><?= $b->jenis_barang ?></td>
                        <td><?= $b->penerima ?></td>
                        <td><?= $b->security ?></td>
                        <td><?= $b->location ?></td>
                        <td><span class="badge bg-secondary"><?= $b->tanggal ?></span></td>
                        <td><?= $b->waktu_masuk ?></td>
                        <td>
                            <?php if(!empty($b->foto) && file_exists(FCPATH.'uploads/barang/'.$b->foto)): ?>
                                <img src="<?= base_url('uploads/barang/'.$b->foto) ?>" alt="Item Photo" class="foto-barang"
                                         data-bs-toggle="modal" data-bs-target="#fotoModal"
                                         data-src="<?= base_url('uploads/barang/'.$b->foto) ?>"
                                         title="Click to view photo">
                            <?php else: ?>
                                <span class="badge bg-danger"><i class="fa fa-times-circle me-1"></i> No Photo</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="d-flex justify-content-center gap-1">
                                <a href="<?= site_url('barang_masuk_controller/edit/'.$b->id) ?>" class="btn btn-sm-action btn-warning" title="Edit Data">
                                    <i class="fa fa-edit"></i> Edit
                                </a>
                                
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="card-footer bg-light d-flex justify-content-between align-items-center p-3">
            <a href="<?= site_url('dashboard/user') ?>" class="btn btn-outline-secondary shadow-sm">
                <i class="fa fa-arrow-left me-1"></i> Back to Dashboard
            </a>
            <div id="pagination" class="d-flex gap-1"></div>
        </div>
    </div>
</div>

<div class="modal fade" id="fotoModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title">
          <i class="fa fa-camera me-1"></i> Item Photo Preview
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>

      <div class="modal-body text-center p-4 position-relative bg-light">
        <a id="downloadFotoBtn" href="#" download
           class="btn btn-success position-absolute"
           style="top: 15px; right: 15px; z-index: 10;">
          <i class="fa fa-download me-1"></i> Download
        </a>

        <img id="previewFoto" src="" class="modal-img rounded shadow-lg"
             alt="Item Photo" style="max-height: 75vh; width: auto;">
      </div>
    </div>
  </div>
</div>


<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js"></script>

<script>
const rowsPerPage = 12; 
let currentPage = 1;
let tableRows = document.querySelectorAll("#barangTable tbody tr");

function applyFilterAndPaginate() {
    const searchText = document.getElementById('searchInput').value.toLowerCase();
    const filterDate = document.getElementById('filterTanggal').value;
    const filteredRows = [];

    tableRows.forEach(row => {
        // Renaming data attributes for clarity in English context
        const sender = row.getAttribute('data-pengirim'); 
        const vendor = row.getAttribute('data-vendor');
        const reg = row.getAttribute('data-reg');
        const date = row.getAttribute('data-tanggal');

        // Check for matches
        const isMatchSearch = searchText === '' || sender.includes(searchText) || vendor.includes(searchText) || reg.includes(searchText);
        const isMatchDate = filterDate === '' || date === filterDate;

        if (isMatchSearch && isMatchDate) filteredRows.push(row);
        else row.style.display = 'none';
    });

    const totalRows = filteredRows.length;
    const totalPages = Math.ceil(totalRows / rowsPerPage);
    tableRows.forEach(row => row.style.display = 'none');
    const start = (currentPage - 1) * rowsPerPage;
    const end = start + rowsPerPage;
    filteredRows.slice(start, end).forEach(row => row.style.display = '');

    const pagination = document.getElementById("pagination");
    pagination.innerHTML = "";
    if (totalPages > 1) {
        const prevBtn = document.createElement("button");
        prevBtn.innerText = '«';
        prevBtn.className = "btn btn-sm btn-outline-primary";
        prevBtn.disabled = currentPage === 1;
        prevBtn.onclick = () => { currentPage--; applyFilterAndPaginate(); };
        pagination.appendChild(prevBtn);

        for(let i=1; i<=totalPages; i++) {
            let btn = document.createElement("button");
            btn.innerText = i;
            btn.className = "btn btn-sm " + (i===currentPage ? "btn-primary" : "btn-outline-primary");
            btn.onclick = () => { currentPage = i; applyFilterAndPaginate(); };
            pagination.appendChild(btn);
        }

        const nextBtn = document.createElement("button");
        nextBtn.innerText = '»';
        nextBtn.className = "btn btn-sm btn-outline-primary";
        nextBtn.disabled = currentPage === totalPages;
        nextBtn.onclick = () => { currentPage++; applyFilterAndPaginate(); };
        pagination.appendChild(nextBtn);
    }
}

document.getElementById('searchInput').addEventListener('keyup', () => { currentPage = 1; applyFilterAndPaginate(); });
document.getElementById('filterTanggal').addEventListener('change', () => { currentPage = 1; applyFilterAndPaginate(); });
document.getElementById('clearFilter').addEventListener('click', () => {
    document.getElementById('searchInput').value = '';
    document.getElementById('filterTanggal').value = '';
    currentPage = 1;
    applyFilterAndPaginate();
});

window.onload = applyFilterAndPaginate;

// 🧾 Export based on filter
document.getElementById("exportExcel").addEventListener("click", function() {
    const search = document.getElementById("searchInput").value;
    const tanggal = document.getElementById("filterTanggal").value;
    const url = `<?= site_url('barang_masuk_controller/export_excel') ?>?search=${encodeURIComponent(search)}&tanggal=${encodeURIComponent(tanggal)}`;
    window.location.href = url;
});

document.getElementById("exportPDF").addEventListener("click", function() {
    const search = document.getElementById("searchInput").value;
    const tanggal = document.getElementById("filterTanggal").value;
    const url = `<?= site_url('barang_masuk_controller/export_pdf') ?>?search=${encodeURIComponent(search)}&tanggal=${encodeURIComponent(tanggal)}`;
    window.location.href = url;
});

// SweetAlert & Photo Preview
<?php if(isset($this->session) && $this->session->flashdata('success')): ?>
Swal.fire({ icon: 'success', title: 'Success!', text: '<?= $this->session->flashdata('success') ?>', timer: 3000 });
<?php endif; ?>

document.querySelectorAll('.btnDelete').forEach(btn => {
    btn.addEventListener('click', function(e){
        e.preventDefault();
        const url = this.dataset.url;
        Swal.fire({
            title: 'Are you sure you want to delete this data?',
            text: "Deleted data cannot be recovered!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, Delete!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) window.location.href = url;
        });
    });
});

const fotoModal = document.getElementById('fotoModal');
fotoModal.addEventListener('show.bs.modal', event => {
    let img = event.relatedTarget;
    const imgSrc = img.getAttribute('data-src');
    document.getElementById('previewFoto').src = imgSrc;
    
    // Set download link and filename
    document.getElementById('downloadFotoBtn').href = imgSrc;
    const filename = imgSrc.substring(imgSrc.lastIndexOf('/') + 1);
    document.getElementById('downloadFotoBtn').setAttribute('download', filename);
});
</script>

</body>
</html>