<?php
// Set timezone ke WIB
date_default_timezone_set('Asia/Jakarta');

// Format Tanggal Hari Ini (Indonesia/WIB)
$date_format = date('l, d F Y');

// Tentukan ucapan sesuai jam
$hour = date('H'); 
$icon_class = 'fa-sun'; // Default icon

if ($hour >= 5 && $hour < 12) {
    $greeting = "Good Morning";
    $icon_class = 'fa-cloud-sun';
} elseif ($hour >= 12 && $hour < 15) {
    $greeting = "Good Afternoon";
    $icon_class = 'fa-sun';
} elseif ($hour >= 15 && $hour < 18) {
    $greeting = "Good Afternoon"; 
    $icon_class = 'fa-cloud-sun-rain';
} else {
    $greeting = "Good Night";
    $icon_class = 'fa-moon';
}

// Data user & dashboard
$username = isset($username) ? $username : $this->session->userdata('username');
$total_admin = isset($total_admin) ? $total_admin : 0; 
$total_tamu_hari_ini = isset($total_tamu_hari_ini) ? $total_tamu_hari_ini : 0; 
$total_barang_masuk = isset($total_barang_masuk) ? $total_barang_masuk : 0; 
$total_barang_keluar = isset($total_barang_keluar) ? $total_barang_keluar : 0;
?>
<!DOCTYPE html>
<html>
<head>
    <title>Guestbook administrator ASI</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">
    <style>
        body {
            background-image: url('<?= base_url("asset/img/log.jpg") ?>');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-attachment: fixed;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            min-height: 100vh;
            padding-bottom: 80px; 
        }

        /* Navbar */
        .navbar {
            border-bottom: 3px solid #ffc107; 
        }
        .navbar-brand {
            font-weight: bold;
            font-size: 1.5rem;
            color: #1e3c72 !important;
        }

        /* Dashboard Header */
        .dashboard-header {
            background: linear-gradient(to bottom, #ffffff 0%, #093b91ff 100%);
            color: #ffffff; 
            padding: 50px 20px;
            border-radius: 25px; 
            margin: 40px auto 20px auto; 
            text-align: center;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3); 
            position: relative;
            overflow: hidden;
            max-width: 1000px;
        }

        /* Logo di header */
        .logo-container {
            text-align: center;
            margin-bottom: 15px;
            animation: fadeIn 1s ease-in;
        }

        .logo-container img {
            height: 90px;
            max-width: 100%;
            object-fit: contain;
            filter: drop-shadow(0px 4px 6px rgba(0,0,0,0.3));
        }

        @keyframes fadeIn {
            from {opacity: 0; transform: translateY(-10px);}
            to {opacity: 1; transform: translateY(0);}
        }

        /* Summary Card */
        .summary-card {
            border-radius: 15px;
            padding: 20px;
            transition: all 0.3s ease;
            height: 100%;
            background-color: #fff;
            border: 1px solid #dee2e6;
            box-shadow: 0 4px 10px rgba(0,0,0,0.05);
        }
        .summary-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 15px rgba(0, 0, 0, 0.1);
        }
        .summary-card h4 {
            font-size: 2.5rem;
            font-weight: bold;
            margin-bottom: 0;
        }
        .summary-card p {
            font-size: 0.85rem;
            color: #6c757d;
            text-transform: uppercase;
        }

        /* Card Menu Utama */
        .card-menu {
            border-radius: 15px;
            transition: all 0.3s ease;
            background-color: #ffffff;
            border: 1px solid #e9ecef;
            height: 100%;
        }
        .card-menu:hover {
            transform: scale(1.02);
            box-shadow: 0px 8px 15px rgba(0,0,0,0.1);
            background-color: #f8f9fa;
        }
        .icon-box {
            font-size: 2.5rem;
            margin-bottom: 15px;
            line-height: 1;
        }
        .card-menu h5 {
            font-weight: bold;
            color: #1e3c72;
        }

        /* Footer */
        footer {
            padding: 20px 0;
            background: #212529;
            color: #adb5bd;
            text-align: center;
            width: 100%;
            position: fixed; 
            bottom: 0;
            left: 0;
            z-index: 999;
        }
    </style>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
    <div class="container-fluid">
        
        <a class="navbar-brand d-flex align-items-center" href="<?= site_url('dashboard') ?>">
            <img src="<?= base_url('asset/img/asiaserv-logo.png') ?>" alt="Logo" height="50" class="me-2">
            <span class="fw-bold fs-5 text-primary">Guest Book Admin</span>
        </a> 
        
        <div class="ms-auto">
            <ul class="navbar-nav">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle d-flex align-items-center p-0" href="#" id="userDropdown" role="button" 
                        data-bs-toggle="dropdown" aria-expanded="false">
                        <img src="<?= base_url('asset/img/admin/' . ($this->session->userdata('foto') ?: 'default.png')) ?>" 
                            alt="User Foto" class="rounded-circle me-1" width="32" height="32" style="object-fit: cover;">
                        <span class="fw-semibold d-none d-lg-inline me-1"><?= $this->session->userdata('nama_lengkap') ?: 'Admin' ?></span>
                    </a>

                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
                        <li><a class="dropdown-item" href="<?= site_url('profile') ?>"><i class="fa fa-user-circle me-2"></i> My Profile</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item text-danger" href="<?= site_url('auth/logout') ?>"><i class="fa fa-sign-out-alt me-2"></i> Log Out</a></li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
</nav>

<div class="container">
    <div class="dashboard-header">
        <div class="logo-container"> 
            <img src="<?= base_url('asset/img/asiaserv-logo.png') ?>" alt="AsiaServ Logo">
        </div>

        <h2 class="fw-light mb-2"> 
            <i class="fa <?= $icon_class ?> me-3"></i><?= $greeting ?>, 
            <span class="fw-bold"><?= $username ?></span>!
        </h2>

        <p class="datetime-info">
            <i class="fa fa-calendar-alt me-2"></i> <?= $date_format ?> 
            <span class="mx-3">|</span> 
            <i class="fa fa-clock me-2"></i> <span id="current-time"></span> WIB 
        </p>

        <p class="mb-0">Welcome to the central command center. Manage your guest list and goods data here. 🌟</p>
    </div>

    <h4 class="mt-4 mb-3 text-white text-center fw-semibold text-shadow">Current Data Overview</h4>
    <div class="row g-4 mb-5 justify-content-center">
        <div class="col-lg-3 col-md-6 col-sm-12">
            <div class="card summary-card text-center">
                <i class="fa fa-address-book fa-2x text-success mb-2"></i>
                <p class="mb-0">Guests Today</p>
                <h4 class="text-success"><?= $total_tamu_hari_ini ?></h4>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-12">
            <div class="card summary-card text-center">
                <i class="fa fa-box-open fa-2x text-primary mb-2"></i>
                <p class="mb-0">Total Incoming Goods</p>
                <h4 class="text-primary"><?= $total_barang_masuk ?></h4>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-12">
            <div class="card summary-card text-center">
                <i class="fa fa-box fa-2x text-danger mb-2"></i>
                <p class="mb-0">Total Exit Item</p>
                <h4 class="text-danger"><?= $total_barang_keluar ?></h4>
            </div>
        </div>
    </div>

    <h4 class="mt-4 mb-3 text-white text-center fw-semibold text-shadow">Admin Menu & Actions</h4>
    <div class="row g-4 mb-5 justify-content-center">
        <div class="col-lg-3 col-md-6 col-sm-12">
            <div class="card card-menu text-center shadow-sm p-3">
                <div class="icon-box text-primary"><i class="fa fa-user-shield"></i></div>
                <h5 class="card-title">Master User</h5>
                <p class="card-text text-muted small">Manage all admin and user accounts.</p>
                <a href="<?= site_url('user_controller') ?>" class="btn btn-primary w-100">
                    <i class="fa fa-cog me-1"></i> Manage Users
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-12">
            <div class="card card-menu text-center shadow-sm p-3">
                <div class="icon-box text-success"><i class="fa fa-book-reader"></i></div>
                <h5 class="card-title">Guest Report</h5>
                <p class="card-text text-muted small">View all guest history and details.</p>
                <a href="<?= site_url('tamu_controller') ?>" class="btn btn-success w-100">
                    <i class="fa fa-clipboard-list me-1"></i> View All Guests
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-12">
            <div class="card card-menu text-center shadow-sm p-3">
                <div class="icon-box text-primary"><i class="fa fa-box-open"></i></div>
                <h5 class="card-title">Incoming Goods</h5>
                <p class="card-text text-muted small">View history of all recorded incoming items.</p>
                <a href="<?= site_url('barang_masuk_controller/list_admin') ?>" class="btn btn-primary w-100">
                    <i class="fa fa-eye me-1"></i> View Incoming Goods
                </a>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-12">
            <div class="card card-menu text-center shadow-sm p-3">
                <div class="icon-box text-danger"><i class="fa fa-box"></i></div>
                <h5 class="card-title">Exit Item Report</h5>
                <p class="card-text text-muted small">View history of all recorded outgoing items.</p>
                <a href="<?= site_url('barang_keluar_controller/list_admin') ?>" class="btn btn-danger w-100">
                    <i class="fa fa-eye me-1"></i> View Exit Item
                </a>
            </div>
        </div>
    </div>
</div>

<footer>
    <small>© <?= date('Y') ?> Admin Dashboard | Powered by AsiaServ</small>
</footer>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<?php if(isset($this->session) && $this->session->flashdata('success')): ?>
<script>
    Swal.fire({
        icon: 'success',
        title: 'Sukses',
        text: "<?= $this->session->flashdata('success'); ?>",
        showConfirmButton: false,
        timer: 2000
    });
</script>
<?php endif; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    function updateTime() {
        const now = new Date();
        const hours = String(now.getHours()).padStart(2, '0');
        const minutes = String(now.getMinutes()).padStart(2, '0');
        const seconds = String(now.getSeconds()).padStart(2, '0');
        document.getElementById('current-time').textContent = `${hours}:${minutes}:${seconds}`;
    }
    updateTime();
    setInterval(updateTime, 1000);
</script>

</body>
</html>
