<!DOCTYPE html>
<html lang="id">
<head>
    <title>Profil Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">
    <style>
        :root {
            /* Definisi Palet Warna */
            --primary-color: #0d6efd; /* Biru Bootstrap */
            --secondary-color: #6c757d; /* Abu-abu Bootstrap */
            --success-color: #198754; /* Hijau Sukses */
            --gradient-start: #007bff; /* Biru Cerah */
            --gradient-end: #00aaff; /* Biru Langit */
            --shadow-light: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        body {
            background-color: #f0f2f5; 
        }
        
        .profile-container {
            max-width: 800px;
            margin: 50px auto;
        }

        .card {
            border-radius: 20px;
            box-shadow: var(--shadow-light);
            transition: transform 0.3s ease-in-out;
            border: none;
        }
        .card:hover {
            transform: translateY(-5px);
        }

        .card-header {
            background: linear-gradient(135deg, var(--gradient-start), var(--gradient-end));
            color: white;
            font-weight: 700;
            font-size: 1.5rem;
            border-top-left-radius: 20px;
            border-top-right-radius: 20px;
            padding: 20px;
        }

        /* Styling untuk area foto profil */
        .profile-photo {
            padding: 20px;
            background-color: #ffffff;
            border-radius: 20px;
            margin-bottom: 20px;
        }
        @media (min-width: 768px) {
            .profile-photo {
                margin-bottom: 0;
            }
        }

        /* Gambar Profil */
        .profile-photo img {
            border-radius: 50%;
            border: 6px solid var(--gradient-end);
            width: 100%;
            max-width: 180px;
            height: 180px;
            object-fit: cover;
            box-shadow: 0 0 15px rgba(0, 123, 255, 0.4);
            cursor: pointer; /* Menandakan bahwa elemen dapat diklik */
            transition: all 0.5s cubic-bezier(0.25, 0.46, 0.45, 0.94);
        }
        .profile-photo img:hover {
            transform: scale(1.05) rotate(3deg);
            border-color: var(--primary-color);
        }
        
        /* Tambahan: Mengatur gambar di dalam Modal */
        #profilePhotoModal .modal-content {
            background: transparent;
            border: none;
        }
        #profilePhotoModal .modal-body {
            padding: 0;
            text-align: center;
        }
        #profilePhotoModal img {
            max-width: 100%;
            height: auto;
            border-radius: 10px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.3);
        }

        /* Styling List Group dan Tombol (Sama seperti sebelumnya) */
        .list-group-item {
            font-size: 1.05rem;
            padding: 15px 20px;
            border: none;
            border-bottom: 1px solid #eee;
            background-color: transparent;
        }
        .list-group-item:last-child {
            border-bottom: none;
        }
        .list-group-item strong {
            color: var(--primary-color);
            min-width: 150px; 
        }
        .list-group-item span {
            color: #333;
            font-weight: 500;
        }

        .btn-back {
            background: var(--secondary-color);
            color: white;
            border-radius: 50px;
            font-weight: 600;
            padding: 10px 25px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            transition: background 0.3s, transform 0.3s;
        }
        .btn-back:hover {
            background: #5a6268;
            transform: translateY(-2px);
            box-shadow: 0 6px 8px rgba(0,0,0,0.2);
            color: white;
        }
    </style>
</head>
<body>

<div class="profile-container">
    <div class="card shadow-lg">
        <div class="card-header text-center">
            ✨ Profil Administrator
        </div>
        <div class="card-body p-4">
            <div class="row">

                <div class="col-12 col-md-4 text-center d-flex justify-content-center align-items-center mb-4 mb-md-0">
                    <div class="profile-photo">
                        <?php
                        $foto = !empty($admin->foto) ? $admin->foto : 'default.png';
                        $foto_url = base_url('asset/img/admin/'.$foto); // Simpan URL foto ke variabel terpisah
                        ?>
                        <a href="#" data-bs-toggle="modal" data-bs-target="#profilePhotoModal">
                            <img src="<?= $foto_url ?>" 
                                 alt="Foto Profil Admin" 
                                 class="img-fluid" 
                                 id="mainProfileImage">
                        </a>
                        <h4 class="mt-3 fw-bold text-dark"><?= $admin->username ?? 'Admin User' ?></h4>
                    </div>
                </div>
                
                <div class="col-12 col-md-8">
                    <ul class="list-group list-group-flush border rounded-3 shadow-sm">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <strong><span class="me-2">📝</span> Nama Lengkap:</strong> 
                            <span class="text-end"><?= $admin->nama_lengkap ?? '-' ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <strong><span class="me-2">💼</span> Job:</strong> 
                            <span class="text-end"><?= $admin->job ?? '-' ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <strong><span class="me-2">🎂</span> Tgl Lahir:</strong> 
                            <span class="text-end"><?= $admin->dob ?? '-' ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <strong><span class="me-2">📧</span> Email:</strong> 
                            <span class="text-end"><?= $admin->email ?? '-' ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <strong><span class="me-2">🛡️</span> Role:</strong> 
                            <span class="badge bg-primary text-end"><?= ucfirst($admin->role ?? 'N/A') ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <strong><span class="me-2">📅</span> Tanggal Dibuat:</strong> 
                            <span class="text-end text-muted small"><?= $admin->created_at ?? '-' ?></span>
                        </li>
                    </ul>

                    <div class="mt-4 text-start">
                        <a href="<?= base_url('index.php/dashboard') ?>" 
                           class="btn btn-back">
                            <span class="me-2">🔙</span> Kembali ke Dasboard
                        </a>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="profilePhotoModal" tabindex="-1" aria-labelledby="profilePhotoModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header border-0 bg-transparent p-2">
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close" style="filter: invert(100%);"></button>
      </div>
      <div class="modal-body">
        <img src="<?= $foto_url ?>" alt="Foto Profil Diperbesar">
      </div>
    </div>
  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>