<!DOCTYPE html>
<html>
<head>
    <title>Edit Guest</title>
    <meta charset="UTF-8">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">
    <style>
        body {
            background: #f4f7f9;
            font-family: 'Poppins', sans-serif;
            padding-top: 50px;
            padding-bottom: 50px;
        }
        .card-custom {
            max-width: 800px;
            margin: auto;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.15);
            border: none;
        }
        .card-header-custom {
            background: linear-gradient(45deg, #0d6efd, #0dcaf0); 
            color: white;
            font-weight: 700;
            font-size: 1.5rem;
            border-top-left-radius: 20px;
            border-top-right-radius: 20px;
            padding: 25px;
            display: flex;
            align-items: center;
        }
        .form-label {
            font-weight: 600;
            color: #343a40;
        }
        .form-control, textarea {
            border-radius: 10px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.08) !important;
            transition: 0.2s;
        }
        .form-control:focus, textarea:focus {
            border-color: #0d6efd;
            box-shadow: 0 0 8px rgba(13, 110, 253, 0.3) !important;
        }
        .btn-gradient {
            background: linear-gradient(90deg, #198754, #20c997);
            color: white;
            font-weight: 600;
            border: none;
            border-radius: 12px;
            min-width: 180px;
            padding: 10px 20px;
            transition: all 0.3s ease;
        }
        .btn-gradient:hover {
            background: linear-gradient(90deg, #20c997, #198754);
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(32, 201, 151, 0.5);
        }
        .btn-secondary-custom {
            border-radius: 12px;
            min-width: 120px;
            font-weight: 500;
            padding: 10px 20px;
        }
        .form-section-title {
            font-size: 1.1rem;
            color: #0d6efd;
            font-weight: 600;
            margin-bottom: 20px;
            padding-bottom: 5px;
            border-bottom: 1px dashed #ced4da;
        }
    </style>
</head>
<body class="container">

<div class="card card-custom">
    
    <div class="card-header-custom">
        <i class="bi bi-person-fill-gear me-2"></i> Edit Guest Data
        <span class="ms-auto badge bg-light text-primary fs-6">ID: <?= $tamu->id ?></span>
    </div>

    <div class="card-body p-4 p-md-5">

        <form id="editTamuForm" method="post" action="<?= site_url('Tamu_controller/update/'.$tamu->id) ?>">

            <div class="form-section-title"><i class="bi bi-person-badge me-2"></i> Identity Data</div>
            <div class="row g-4 mb-4">
                <div class="col-md-6">
                    <label class="form-label"><i class="bi bi-person me-1"></i> Full Name</label>
                    <input type="text" name="nama" class="form-control" placeholder="Guest's Full Name" value="<?= $tamu->nama ?>" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label"><i class="bi bi-building me-1"></i> Institution/Company</label>
                    <input type="text" name="instansi" class="form-control" placeholder="Institution/Company of Origin" value="<?= $tamu->instansi ?>">
                </div>
                <div class="col-md-6">
                    <label class="form-label"><i class="bi bi-phone me-1"></i> Phone Number</label>
                    <input type="text" name="no_handphone" class="form-control" placeholder="Guest's Phone Number" value="<?= $tamu->no_handphone ?>">
                </div>
                <div class="col-md-6">
                    <label class="form-label"><i class="bi bi-telephone me-1"></i> Visitor Number (ASI)</label>
                    <input type="text" name="no_visitor" class="form-control" placeholder="Visitor Card ID" value="<?= $tamu->no_visitor ?>">
                </div>
                <div class="col-md-6">
                    <label class="form-label"><i class="bi bi-hash me-1"></i> Guest Number (Arkadia)</label>
                    <input type="text" name="no_tamu" class="form-control" placeholder="Guest Sequence Number" value="<?= $tamu->no_tamu ?>" required>
                </div>
            </div>

            <div class="form-section-title"><i class="bi bi-clock-history me-2"></i> Visit Details</div>
            <div class="row g-4">
                <div class="col-12 mb-3">
                    <label class="form-label"><i class="bi bi-chat-dots me-1"></i> Purpose</label>
                    <textarea name="keperluan" class="form-control" rows="3" placeholder="Purpose and Needs of the Visit"><?= $tamu->keperluan ?></textarea>
                </div>

                <div class="col-md-6">
                    <label class="form-label"><i class="bi bi-geo-alt me-1"></i> Location</label>
                    <select name="location" class="form-control" required>
                        <option value="">-- Select Location --</option>
                        <option value="Arkadia Head Office" <?= $tamu->location == 'Arkadia Head Office' ? 'selected' : '' ?>>Arkadia Head Office</option>
                        <option value="Workshop BSD" <?= $tamu->location == 'Workshop BSD' ? 'selected' : '' ?>>Workshop BSD</option>
                    </select>
                </div>

                <div class="col-md-3">
                    <label class="form-label"><i class="bi bi-arrow-down-right-circle me-1"></i> Entry Time</label>
                    <input type="time" name="waktu_masuk" class="form-control" value="<?= $tamu->waktu_masuk ?>" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label"><i class="bi bi-arrow-up-left-circle me-1"></i> Exit Time</label>
                    <input type="time" name="waktu_keluar" class="form-control" value="<?= $tamu->waktu_keluar ?>">
                    <small class="text-muted">Fill this if the guest has finished their visit.</small>
                </div>
            </div>

            <div class="mt-5 d-flex justify-content-center gap-3">
                <a href="<?= site_url('Tamu_controller') ?>" class="btn btn-secondary-custom">
                    <i class="bi bi-arrow-left me-1"></i> Back
                </a>
                <button type="button" id="btnUpdate" class="btn btn-gradient">
                    <i class="bi bi-check-circle me-1"></i> Update
                </button>
            </div>
        </form>
    </div>
</div>

<script>
$(document).ready(function(){
// ✅ NEW FUNCTION TO AUTO-FILL EXIT TIME
    const waktuKeluarInput = $('#waktu_keluar');
    const waktuKeluarValue = waktuKeluarInput.val();

    // Only auto-fill if Exit Time is EMPTY (meaning the guest hasn't checked out yet)
    if (!waktuKeluarValue) {
        const now = new Date();
        // Format time to HH:MM (Example: 01:27)
        const hours = String(now.getHours()).padStart(2, '0');
        const minutes = String(now.getMinutes()).padStart(2, '0');
        const currentTime = hours + ':' + minutes;
        
        waktuKeluarInput.val(currentTime);
    }
    $('#btnUpdate').on('click', function(e){
        Swal.fire({
            title: 'Confirm Changes', // Terjemahan: Konfirmasi Perubahan
            text: "Are you sure you want to save the changes to this guest's data?", // Terjemahan: Anda yakin ingin menyimpan perubahan data tamu ini?
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#198754',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, Update!', // Terjemahan: Ya, Update!
            cancelButtonText: 'Cancel' // Terjemahan: Batal
        }).then((result) => {
            if (result.isConfirmed) {
                Swal.fire({
                    title: 'Processing...', // Terjemahan: Memproses...
                    text: 'Please wait a moment.', // Terjemahan: Mohon tunggu sebentar.
                    allowOutsideClick: false,
                    didOpen: () => { Swal.showLoading(); }
                });
                $('#editTamuForm').submit();
            }
        });
    });

    <?php if(isset($this->session) && $this->session->flashdata('success')): ?>
    Swal.fire({ icon: 'success', title: 'Success', text: "<?= $this->session->flashdata('success'); ?>", confirmButtonColor: '#198754' }); // Terjemahan: Sukses
    <?php endif; ?>
    <?php if(isset($this->session) && $this->session->flashdata('error')): ?>
    Swal.fire({ icon: 'error', title: 'Failed', text: "<?= $this->session->flashdata('error'); ?>", confirmButtonColor: '#dc3545' }); // Terjemahan: Gagal
    <?php endif; ?>
});
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>