<!DOCTYPE html>
<html>
<head>
    <title>Guest Book Registration</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css"/>
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

    <style>
        :root {
            --color-primary: #194380;
            --color-secondary: #00bcd4;
        }
        body { 
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            background: url("<?= base_url('asset/img/log.jpg') ?>") no-repeat center center fixed;
            background-size: cover; 
            font-family: 'Poppins', sans-serif;
            margin: 0;
        }
        .card {
            max-width: 480px; 
            width: 90%;     
            background: rgba(255, 255, 255, 0.95); 
            border-radius: 20px;
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.4); 
            border: 1px solid rgba(0, 0, 0, 0.1);
            animation: fadeIn 0.8s ease-out;
        }
        .card-header-custom {
            background: var(--color-primary);
            color: white;
            border-radius: 20px 20px 0 0 !important;
            padding: 25px;
        }
        .form-control, .btn, .form-select {
            border-radius: 10px; 
        }
        .form-label {
            font-weight: 600;
            color: var(--color-primary);
        }
        .btn-primary {
            background-color: var(--color-secondary);
            border-color: var(--color-secondary);
            transition: all 0.3s;
            font-weight: 700;
        }
        .btn-primary:hover {
            background-color: #00a4b7;
            border-color: #00a4b7;
        }
        #btnDaftar {
            padding: 15px 30px;
            font-size: 1.5rem;
            box-shadow: 0 5px 15px rgba(0, 187, 212, 0.4);
        }
        .logo-display {
            max-width: 200px;
            height: auto;
            margin-bottom: 25px;
        }
        @keyframes fadeIn {
            from {opacity: 0; transform: scale(0.95);}
            to {opacity: 1; transform: scale(1);}
        }
        /* Border merah + efek getar */
        .border-red-500 {
            border: 2px solid #ff4d4d !important;
            animation: shake 0.3s ease-in-out;
        }
        @keyframes shake {
            0%, 100% { transform: translateX(0); }
            20%, 60% { transform: translateX(-5px); }
            40%, 80% { transform: translateX(5px); }
        }
     /* HP kecil (<= 380px) */
    @media (max-width: 380px) {
        .card {
            padding: 10px;
            border-radius: 15px;
        }

        #btnDaftar {
            font-size: 1.1rem;
            padding: 12px 20px;
        }

        .logo-display {
            max-width: 140px;
        }

        .form-label {
            font-size: 0.9rem;
        }

        .form-control,
        .form-select {
            font-size: 0.9rem;
        }
    }

    /* Tablet portrait (<= 768px) */
    @media (max-width: 768px) {
        body {
            padding: 10px;
        }

        .card {
            max-width: 90%;
        }
    }

    /* Tablet landscape / layar sedang */
    @media (min-width: 769px) and (max-width: 1024px) {
        .card {
            max-width: 550px;
        }
    }
</style>
</head>
<body>

<div class="card shadow-lg border-0">
    <div class="card-header-custom text-center">
        <h3 class="mb-0"><i class="fa fa-book-open me-2"></i> Guest Book</h3>
        <p class="mb-0 small opacity-75">Please fill in your details</p>
    </div>
    <div class="card-body p-4 p-md-5">

        <div id="daftarAwal" class="text-center py-5">
            <img src="<?= base_url('asset/img/asiaserv-logo.png') ?>" 
                 alt="Company Logo" 
                 class="img-fluid logo-display">
            <h5 class="mb-4 text-muted">Tap to start registration:</h5>
            <button id="btnDaftar" class="btn btn-primary">
                <i class="fa fa-hand-pointer me-2"></i> TAP TO REGISTER
            </button>
        </div>

        <form id="formTamu" style="display:none;">
            <input type="hidden" 
                   name="<?= $this->security->get_csrf_token_name(); ?>" 
                   value="<?= $this->security->get_csrf_hash(); ?>">

            <div class="row g-3">
    <div class="col-12">
        <label for="nama" class="form-label"><i class="fa fa-user me-1"></i> Full Name</label>
        <input type="text" id="nama" name="nama" class="form-control form-control-lg" placeholder="Enter Your Name" required>
    </div>

    <div class="col-12">
        <label for="instansi" class="form-label"><i class="fa fa-building me-1"></i> Company / Organization</label>
        <input type="text" id="instansi" name="instansi" class="form-control" placeholder="Company Name or Personal" required>
    </div>

    <div class="col-12">
        <label for="no_handphone" class="form-label"><i class="fa fa-phone me-1"></i> No. Handphone</label>
        <input type="text" id="no_handphone" name="no_handphone" class="form-control" placeholder="Enter Phone Number" required>
    </div>
    <div class="col-md-6">
        <label for="no_tamu" class="form-label"><i class="fa fa-id-card me-1"></i> No Visitor</label>
        <input type="text" id="no_tamu" name="no_tamu" 
                class="form-control" 
                value="<?= isset($no_tamu) ? htmlspecialchars($no_tamu) : '' ?>" 
                placeholder="Enter ID/Badge Number" required>
    </div>

    <div class="col-md-6">
        <label for="waktu_masuk" class="form-label"><i class="fa fa-clock me-1"></i> Time In</label>
        <input type="time" id="waktu_masuk" name="waktu_masuk" class="form-control" required>
    </div>
</div>

            <!-- Kolom lokasi -->
            <div class="mb-3 mt-3">
                <label for="location" class="form-label"><i class="fa fa-map-marker-alt me-1"></i> Location</label>
                <select id="location" name="location" class="form-select" required>
                    <option value="">-- Select Location --</option>
                    <option value="Arkadia Head Office">Arkadia Head Office</option>
                    <option value="Workshop BSD">Workshop BSD</option>
                </select>
            </div>

            <div class="mb-3">
                <label for="keperluan" class="form-label"><i class="fa fa-comment me-1"></i> Purpose of Visit</label>
                <textarea id="keperluan" name="keperluan" class="form-control" rows="3" placeholder="Enter purpose of visit" required></textarea>
            </div>

            <div class="d-grid gap-2 mt-4">
                <button type="submit" class="btn btn-primary btn-lg">
                    <i class="fa fa-check-circle me-1"></i> Submit & Save
                </button>
                <button type="button" id="btnCancel" class="btn btn-outline-secondary btn-sm mt-2">
                    <i class="fa fa-times me-1"></i> Cancel
                </button>
            </div>
        </form>
    </div>
</div>

<script>
$(document).ready(function(){
    function setCurrentTime() {
        const now = new Date();
        const hours = String(now.getHours()).padStart(2, '0');
        const minutes = String(now.getMinutes()).padStart(2, '0');
        $('#waktu_masuk').val(`${hours}:${minutes}`);
    }

    // Tombol Register → tampilkan form
    $('#btnDaftar').click(function(){
        $('#daftarAwal').slideUp(300, function() {
            $('#formTamu').fadeIn(500);
            setCurrentTime();
            $('#nama').focus();
        });
    });

    // Tombol Cancel → kembali ke awal
    $('#btnCancel').click(function(){
        $('#formTamu').slideUp(300, function() {
            $('#formTamu')[0].reset();
            $('#daftarAwal').fadeIn(500);
            $('#formTamu input, #formTamu select, #formTamu textarea').removeClass('border-red-500');
        });
    });

    // Hapus warna merah saat user isi
    $('#formTamu input, #formTamu select, #formTamu textarea').on('input change', function(){
        if ($(this).val().trim() !== '') {
            $(this).removeClass('border-red-500');
        }
    });

    // Validasi & submit form
    $('#formTamu').on('submit', function(e){
        e.preventDefault();

        let isValid = true;
        $('#formTamu [required]').each(function(){
            if ($(this).val().trim() === '') {
                $(this).addClass('border-red-500');
                isValid = false;
            } else {
                $(this).removeClass('border-red-500');
            }
        });

        if (!isValid) {
            Swal.fire({
                icon: 'warning',
                title: 'Incomplete Form',
                text: 'Please fill out all required fields before submitting.',
                confirmButtonColor: '#194380'
            });
            return;
        }

        // Loading SweetAlert
        Swal.fire({
            title: 'Submitting Data...',
            text: 'Please wait a moment.',
            allowOutsideClick: false,
            showConfirmButton: false,
            didOpen: () => Swal.showLoading()
        });

        $.ajax({
            url: "<?= site_url('Tamu_controller/simpan_ajax') ?>",
            type: "POST",
            data: $(this).serialize(),
            dataType: "json",
            success: function(res){
                Swal.close();
                if(res.status === 'success'){
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: res.message,
                        confirmButtonColor: '#194380'
                    });
                    $('#formTamu')[0].reset();
                    $('#formTamu').slideUp(300, function() {
                        $('#daftarAwal').fadeIn(500);
                    });
                } else { 
                    Swal.fire({
                        icon: 'error',
                        title: 'Failed',
                        text: res.message
                    });
                }
            },
            error: function(xhr){
                Swal.close();
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'An error occurred: ' + xhr.statusText
                });
            }
        });
    });
});
</script>

</body>
</html>
