<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Laporan Buku Tamu</title>
    <style>
        body { font-family: sans-serif; font-size: 10px; margin: 0; padding: 20px; }
        .header { text-align: center; margin-bottom: 15px; position: relative; }
        .header img { position: absolute; left: 0; top: 0; height: 45px; }
        .title { font-size: 18px; font-weight: bold; margin-bottom: 5px; color: #0D6EFD; }
        .subtitle { font-size: 12px; margin-top: 5px; }
        .date { font-size: 10px; color: #555; }
        .printed-by { font-size: 10px; color: #000; margin-top: 3px; }

        table { width: 100%; border-collapse: collapse; margin-top: 15px; table-layout: fixed; }
        th, td { border: 1px solid #000; padding: 5px 3px; font-size: 9px; vertical-align: middle; }
        th { background-color: #0D6EFD; color: white; font-weight: bold; height: 25px; text-align: center; }

        .data-center { text-align: center; }
        .col-nama, .col-instansi, .col-keperluan { text-align: center; word-wrap: break-word; }

        .w-3 { width: 3%; } .w-12 { width: 12%; } .w-7 { width: 7%; } 
        .w-20 { width: 20%; } .w-10 { width: 10%; }

        .page-footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            text-align: right;
            border-top: 1px solid #000;
            padding-top: 5px;
            font-size: 9px;
        }
    </style>
</head>
<body>
<?php 
date_default_timezone_set('Asia/Jakarta');
$tgl_dari = isset($tanggal_dari) && !empty($tanggal_dari) ? date('d F Y', strtotime($tanggal_dari)) : 'Awal Data';
$tgl_sampai = isset($tanggal_sampai) && !empty($tanggal_sampai) ? date('d F Y', strtotime($tanggal_sampai)) : 'Akhir Data';
$username = isset($username) ? $username : ($this->session->userdata('nama_lengkap') ?? $this->session->userdata('username') ?? 'Tidak diketahui');
?>

<div class="header">
    <?php
$logoPath = FCPATH . 'asset/img/asiaserv-logo.png';
$logoBase64 = '';
if (file_exists($logoPath)) {
    $logoData = file_get_contents($logoPath);
    $logoBase64 = 'data:image/png;base64,' . base64_encode($logoData);
}
?>
<?php if ($logoBase64): ?>
    <img src="<?= $logoBase64 ?>" alt="Logo" style="height:45px; position:absolute; left:0; top:0;">
<?php endif; ?>

    <div class="title">LAPORAN BUKU TAMU VISITORS</div>
    <div class="subtitle">Periode: <?= $tgl_dari ?> s/d <?= $tgl_sampai ?></div>
    <div class="date">Dicetak pada: <?= date('d-m-Y H:i') ?></div>
    <div class="printed-by">Dicetak oleh: <?= htmlspecialchars($username) ?></div>
</div>

<table>
    <thead>
        <tr>
            <th class="w-3">No</th>
            <th class="w-12">Name</th>
            <th class="w-12">Company/Personal</th>
            <th class="w-7">ASI No</th>
            <th class="w-7">ARK No</th>
            <th class="w-20">Purpose</th>
            <th class="w-10">Location</th>
            <th class="w-7">Date</th>
            <th class="w-7">Time In</th>
            <th class="w-7">Time Out</th>
        </tr>
    </thead>
    <tbody>
        <?php $no=1; foreach($tamu as $row): ?>
        <tr>
            <td class="w-3 data-center"><?= $no++ ?></td>
            <td class="w-12 col-nama"><?= htmlspecialchars($row->nama) ?></td>
            <td class="w-12 col-instansi"><?= htmlspecialchars($row->instansi) ?></td>
            <td class="w-7 data-center"><?= htmlspecialchars($row->no_visitor) ?></td>
            <td class="w-7 data-center"><?= htmlspecialchars($row->no_tamu) ?></td>
            <td class="w-20 col-keperluan"><?= htmlspecialchars($row->keperluan) ?></td>
            <td class="w-10 data-center"><?= htmlspecialchars($row->location ?? '-') ?></td>
            <td class="w-7 data-center"><?= !empty($row->created_at) ? date('d-m-Y', strtotime($row->created_at)) : '' ?></td>
            <td class="w-7 data-center"><?= htmlspecialchars($row->waktu_masuk) ?></td>
            <td class="w-7 data-center"><?= htmlspecialchars($row->waktu_keluar) ?></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<script type="text/php">
if ( isset($pdf) ) {
    $font = $fontMetrics->get_font("sans-serif", "normal");
    $size = 8;
    $text = "Halaman {PAGE_NUM} dari {PAGE_COUNT}";
    $x = 780 - $fontMetrics->get_text_width($text, $font, $size);
    $y = 570;
    $pdf->page_text($x, $y, $text, $font, $size);
}
</script>
</body>
</html>
